/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SMDispatcher;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.export.ISiteExportManager;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import javax.naming.InitialContext;

public class ExportSiteTitlesMessageDispatcher
extends SMDispatcher {
    private static final String INCLUDE_TARGETED = "IncludeTargeted";
    private static final String INCLUDE_READY_FOR_DIST = "IncludeReadyForDistribution";
    private static final String INCLUDE_IN_PROGRESS = "IncludeInProgress";
    private static final String INCLUDE_DISTRIBUTED = "IncludeDistributed";
    private static final String INCLUDE_FAILED = "IncludeFailed";
    private static final String FILEPATH = "FilePath";
    private static final String OUTPUT_FILEPATH = "OutputFilePath";

    public ExportSiteTitlesMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public WorkflowMessage generateResponse(WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{"SiteID"});
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{INCLUDE_TARGETED});
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{INCLUDE_READY_FOR_DIST});
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{INCLUDE_IN_PROGRESS});
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{INCLUDE_DISTRIBUTED});
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{INCLUDE_FAILED});
        Long siteId = Util.getLongValue((WorkflowMessage)message, (String)"SiteID");
        ArrayList<DistributionStatus> statusList = new ArrayList<DistributionStatus>();
        if (Util.getBooleanValue((WorkflowMessage)message, (String)INCLUDE_TARGETED)) {
            statusList.add(DistributionStatus.TARGETED);
        }
        if (Util.getBooleanValue((WorkflowMessage)message, (String)INCLUDE_READY_FOR_DIST)) {
            statusList.add(DistributionStatus.READY_FOR_DISTRIBUTION);
        }
        if (Util.getBooleanValue((WorkflowMessage)message, (String)INCLUDE_IN_PROGRESS)) {
            statusList.add(DistributionStatus.IN_PROGRESS);
        }
        if (Util.getBooleanValue((WorkflowMessage)message, (String)INCLUDE_DISTRIBUTED)) {
            statusList.add(DistributionStatus.DISTRIBUTED);
        }
        if (Util.getBooleanValue((WorkflowMessage)message, (String)INCLUDE_FAILED)) {
            statusList.add(DistributionStatus.FAILED);
        }
        if (statusList.isEmpty()) {
            return this.generateNackMessage(message, "Atleast one status must be included in the export.");
        }
        String filePath = Util.getStringValueTrimmed((WorkflowMessage)message, (String)FILEPATH);
        try {
            ISiteExportManager siteExportManager = (ISiteExportManager)new InitialContext().lookup("cms/SiteExportManager/local");
            if (filePath != null) {
                siteExportManager.exportTitles(siteId.intValue(), statusList, filePath);
            } else {
                filePath = siteExportManager.exportTitles(siteId.intValue(), statusList);
            }
        }
        catch (Exception e) {
            String msg = "Failed to export site titles, error: " + e.getMessage();
            return this.generateNackMessage(message, msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(OUTPUT_FILEPATH, filePath);
        return response;
    }
}

