/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SMDispatcher;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class GetSiteForTitleMessageDispatcher
extends SMDispatcher {
    private static final String SITE_MANAGER_SERVICE = "cms/SiteManager/local";
    private static final String SITE_NAME = "SiteName";

    public GetSiteForTitleMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public WorkflowMessage generateResponse(WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{"TitleID"});
        Long titleId = Util.getLongValue((WorkflowMessage)message, (String)"TitleID");
        DistributionSite site = null;
        try {
            ISiteManager siteManager = this.getSiteManager();
            site = siteManager.getAssociatedDistributionSite(titleId.longValue());
        }
        catch (NamingException e) {
            String msg = "Failed to lookup the Site Manager service, error: " + e.getLocalizedMessage();
            return this.generateNackMessage(message, msg);
        }
        catch (RuntimeException e) {
            String msg = "Failed to get the site associated with title[" + titleId + "], error: " + e.getLocalizedMessage();
            return this.generateNackMessage(message, msg);
        }
        if (site == null) {
            String msg = "The title[" + titleId + "] is not associated with a site.";
            return this.generateNackMessage(message, msg);
        }
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        response.putValue("SiteID", site.getId().toString());
        response.putValue(SITE_NAME, site.getName());
        return response;
    }

    private ISiteManager getSiteManager() throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (ISiteManager)initialContext.lookup(SITE_MANAGER_SERVICE);
    }
}

