/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SMDispatcher;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class GetSitePropertiesMessageDispatcher
extends SMDispatcher {
    private Logger logger = Logger.getLogger(GetSitePropertiesMessageDispatcher.class);

    public GetSitePropertiesMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public WorkflowMessage generateResponse(WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{"SiteID"});
        Long siteId = Util.getLongValue((WorkflowMessage)message, (String)"SiteID");
        Site site = null;
        try {
            ISiteManager siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
            this.logger.debug((Object)("Inside " + ((Object)((Object)this)).getClass().getSimpleName() + ", siteId=" + siteId));
            site = siteManager.getSite(siteId.intValue());
        }
        catch (Exception e) {
            String msg = "Failed to obtain the Site, error: " + e.getMessage();
            return this.generateNackMessage(message, msg);
        }
        if (site == null) {
            String msg = "Was not able to obtain a site for a given siteId=" + siteId;
            return this.generateNackMessage(message, msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue("SiteName", site.getName());
        response.putValue("ExternalID", site.getExternalId());
        response.putValue("Type", site.getType().name());
        if (site.getType() == SiteType.DISTRIBUTION) {
            DistributionSite distSite = (DistributionSite)site;
            response.putValue("MetadataFormat", distSite.getMetadataFormat());
            List lookupKeysList = distSite.getFileLookupKeys();
            String lookupKeys = lookupKeysList.toString().substring(1, lookupKeysList.toString().length() - 1);
            response.putValue("LookupKeys", lookupKeys);
        }
        return response;
    }
}

