/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SMDispatcher;
import com.ericsson.cms.sites.core.ISiteManager;
import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class GetSiteTitlesMessageDispatcher
extends SMDispatcher {
    private Logger logger = Logger.getLogger(GetSiteTitlesMessageDispatcher.class);

    public GetSiteTitlesMessageDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public WorkflowMessage generateResponse(WorkflowMessage message) {
        Util.validateRequired((WorkflowMessage)message, (String[])new String[]{"TitleID"});
        Long titleId = Util.getLongValue((WorkflowMessage)message, (String)"TitleID");
        List siteTitles = null;
        try {
            ISiteManager siteManager = (ISiteManager)new InitialContext().lookup("cms/SiteManager/local");
            this.logger.debug((Object)("Inside " + ((Object)((Object)this)).getClass().getSimpleName() + ", titleId=" + titleId));
            siteTitles = siteManager.getSiteCopies(titleId.longValue());
        }
        catch (Exception e) {
            String msg = "Failed to obtain the Site Title copies, error: " + e.getMessage();
            return this.generateNackMessage(message, msg);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        StringBuffer sb = new StringBuffer("");
        if (siteTitles != null && siteTitles.size() > 0) {
            for (Title title : siteTitles) {
                if (!sb.toString().isEmpty()) {
                    sb.append(", ");
                }
                sb.append(title.getId());
            }
        }
        response.putValue("SiteTitleIDs", sb.toString());
        return response;
    }
}

