/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SMDispatcher
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(SMDispatcher.class);

    public SMDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage msg) throws DispatcherException {
        WorkflowMessage message;
        try {
            message = this.getWorkflowMessage(msg);
        }
        catch (Exception e1) {
            String errMsg = "Could not parse the message";
            throw new DispatcherException(errMsg, (Throwable)e1);
        }
        WorkflowMessage response = null;
        try {
            response = this.generateResponse(message);
        }
        catch (RuntimeException e) {
            String errorMessage = "Failed to perform operation, error: " + e.getLocalizedMessage();
            response = this.generateNackMessage(message, errorMessage);
        }
        try {
            Document docResponse = Marshaller.newMarshaller().marshal(response);
            HTTPPayload httpPayload = new HTTPPayload(XMLDocumentUtility.convertToString((Node)docResponse));
            HTTPMessage responseMsg = new HTTPMessage(httpPayload);
            logger.debug((Object)("Generated message: " + responseMsg));
            return responseMsg;
        }
        catch (Exception e) {
            String errMsg = "Could not parse the message";
            throw new DispatcherException(errMsg, (Throwable)e);
        }
    }

    protected abstract WorkflowMessage generateResponse(WorkflowMessage var1);

    protected WorkflowMessage getWorkflowMessage(IMessage message) throws Exception {
        Document doc = XMLDocumentUtility.loadXml((String)message.getPayload().getContent());
        return Unmarshaller.unmarshal((Document)doc);
    }

    protected WorkflowMessage generateNackMessage(WorkflowMessage message, String msg) {
        IMessageUID uid = message != null ? message.getMessageUID() : new MessageUIDImpl("Unknown UID");
        IMessageKey key = message != null ? message.getKey() : null;
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.nack);
        response.putValue("error-message", msg);
        return response;
    }
}

