/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.IContentClassService;
import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.ws.rs.core.Response;

public class ContentClassService
implements IContentClassService {
    private static final String PERMISSION_CONTENT_CLASS_EXPORT = "ContentClassManagement_View";
    private static final String PERMISSION_CONTENT_CLASS_IMPORT_CREATE = "ContentClassManagement_Create";
    private static final String PERMISSION_CONTENT_CLASS_IMPORT_MODIFY = "ContentClassManagement_Modify";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response authenticate(String authorizationHeader) {
        RESTAuthentication auth = null;
        try {
            auth = RESTAuthentication.loginIfHasAllOfThePermissions(authorizationHeader, PERMISSION_CONTENT_CLASS_EXPORT, PERMISSION_CONTENT_CLASS_IMPORT_CREATE, PERMISSION_CONTENT_CLASS_IMPORT_MODIFY);
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    @Override
    public String contentClassExport(String authorizationHeader, String id, boolean partner) {
        RESTAuthentication auth = null;
        String xml = null;
        auth = RESTAuthentication.loginIfHasAllOfThePermissions(authorizationHeader, PERMISSION_CONTENT_CLASS_EXPORT, PERMISSION_CONTENT_CLASS_IMPORT_CREATE, PERMISSION_CONTENT_CLASS_IMPORT_MODIFY);
        if (auth != null) {
            try {
                id = id.trim();
                long lid = 0L;
                try {
                    lid = Long.parseLong(id);
                }
                catch (Exception ex) {
                    return "Error: Invalid content class id: " + id;
                }
                com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
                ContentClass contentClassExport = ccService.getContentClassById(lid);
                if (partner) {
                    List partners = ccService.getContentClassPartnersByContentClassId(lid, true);
                    xml = ccService.marshalContentClassWithPartners(contentClassExport, partners);
                }
                xml = ccService.marshalContentClass(contentClassExport);
            }
            catch (Exception ex) {
                StringWriter strWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(strWriter);
                ex.printStackTrace(writer);
                return "Error: " + strWriter.toString();
            }
        } else {
            return "Error: Invalid user/password.";
        }
        return xml;
    }

    private void saveContentClass(ContentClass cc) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        Long id = ccService.getContentClassIdByName(cc.getName());
        if (id != null) {
            cc.setId(id.longValue());
        }
        if ("Default".equals(cc.getName())) {
            cc.setDefault(true);
        }
        ccService.saveContentClass(cc);
    }

    @Override
    public String contentClassImport(String authorizationHeader, String xml, String partner) {
        RESTAuthentication auth = null;
        auth = RESTAuthentication.loginIfHasAllOfThePermissions(authorizationHeader, PERMISSION_CONTENT_CLASS_EXPORT, PERMISSION_CONTENT_CLASS_IMPORT_CREATE, PERMISSION_CONTENT_CLASS_IMPORT_MODIFY);
        if (auth == null) {
            return "Error: invalid username/password";
        }
        try {
            if (partner.equalsIgnoreCase("ignore")) {
                return this.doIgnore(xml);
            }
            if (partner.equalsIgnoreCase("updateExisting")) {
                return this.doUpdateExisting(xml);
            }
            if (partner.equalsIgnoreCase("createAndUpdate")) {
                return this.doCreateAndUpdate(xml);
            }
            return "Error: Invalid partner option: " + partner;
        }
        catch (Exception ex) {
            StringWriter strWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(strWriter);
            ex.printStackTrace(writer);
            return "Error: " + strWriter.toString();
        }
    }

    private String doIgnore(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        ContentClass ccImport = ccService.unmarshalContentClass(xml);
        this.saveContentClass(ccImport);
        return "The content class " + ccImport.getName() + " was imported successfully";
    }

    private String doUpdateExisting(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        StringBuilder partnersMessage = new StringBuilder();
        ArrayList partnersToImport = new ArrayList();
        ContentClass ccImport = ccService.unmarshalContentClassWithPartners(xml, partnersToImport);
        this.saveContentClass(ccImport);
        List partnersToUpdate = ccService.getContentClassPartnersByContentClassId(ccImport.getId(), false);
        if (partnersToUpdate != null && partnersToUpdate.size() > 0) {
            for (ContentClassPartner cp : partnersToUpdate) {
                for (ContentClassPartner cpI : partnersToImport) {
                    Long pid;
                    if (!cpI.getContentClassName().equals(cp.getContentClassName()) || !cpI.getPartnerName().equals(cp.getPartnerName())) continue;
                    if (cpI.getMetadata() != null) {
                        cp.setMetadata(cpI.getMetadata());
                    }
                    if (cpI.getPartnerName() != null) {
                        cp.setPartnerName(cpI.getPartnerName());
                    }
                    if ((pid = ccService.getPartnerIdByName(cpI.getPartnerName())) != null) {
                        cpI.setPartnerId(pid.longValue());
                    }
                    ccService.saveContentClassPartner(cp);
                    partnersMessage.append(cpI.getPartnerName()).append(" ");
                }
            }
        }
        return "The content class " + ccImport.getName() + " was imported successfully with the following partners:" + partnersMessage.toString();
    }

    private String doCreateAndUpdate(String xml) throws Exception {
        com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
        StringBuilder partnersMessage = new StringBuilder();
        ArrayList partnersToImport = new ArrayList();
        ContentClass ccImport = ccService.unmarshalContentClassWithPartners(xml, partnersToImport);
        this.saveContentClass(ccImport);
        for (ContentClassPartner cc : partnersToImport) {
            Long partnerId = ccService.getPartnerIdByName(cc.getPartnerName());
            if (partnerId == null) {
                throw new Exception("Content Class " + ccImport.getName() + ": Partner with name " + cc.getPartnerName() + " doesn't exist.");
            }
            cc.setContentClassId(ccImport.getId());
            cc.setPartnerId(partnerId.longValue());
            ccService.saveContentClassPartner(cc);
            partnersMessage.append(cc.getPartnerName()).append(" ");
        }
        return "The content class " + ccImport.getName() + " was imported successfully with the following partners: " + partnersMessage.toString();
    }

    @Override
    public String getContentClassIds(String authorizationHeader) {
        ArrayList<Long> contentClassIDList = new ArrayList<Long>();
        RESTAuthentication auth = null;
        auth = RESTAuthentication.loginIfHasAllOfThePermissions(authorizationHeader, PERMISSION_CONTENT_CLASS_EXPORT, PERMISSION_CONTENT_CLASS_IMPORT_CREATE, PERMISSION_CONTENT_CLASS_IMPORT_MODIFY);
        if (auth != null) {
            try {
                com.tandbergtv.content.contentclass.service.IContentClassService ccService = this.getContentClassService();
                List contentClassList = ccService.getAllContentClassesWithoutMetadata();
                for (ContentClass cc : contentClassList) {
                    contentClassIDList.add(cc.getId());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return ((Object)contentClassIDList).toString();
    }

    private com.tandbergtv.content.contentclass.service.IContentClassService getContentClassService() throws Exception {
        InitialContext ctx = new InitialContext();
        com.tandbergtv.content.contentclass.service.IContentClassService service = (com.tandbergtv.content.contentclass.service.IContentClassService)ctx.lookup("cms/ContentClassService/local");
        return service;
    }
}

