/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Authorizer;
import com.tandbergtv.cms.services.ICustomFieldsService;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.model.CustomFields;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;

public class CustomFieldsService
implements ICustomFieldsService {
    private static final Logger logger = Logger.getLogger((String)CustomFieldsService.class.getName());
    private static final String CUSTOM_FIELDS_EXPORT = "CustomFieldsAdministration_View";
    private static final String CUSTOM_FIELDS_IMPORT = "CustomFieldsAdministration_Administer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response authenticate(String userName, String password) {
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occured during authentication of custom fields export/import : " + e), (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
            return response;
        }
        finally {
            securityClient.logout();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    @Override
    public CustomFields customFieldsExport(String userName, String password) {
        CustomFields customFields = new CustomFields();
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            String permission = CUSTOM_FIELDS_EXPORT;
            if (!Authorizer.hasPermission(permission, new String[0])) {
                throw new AuthorizationException("Caller is unauthorized to export custom fields.");
            }
            ICustomFieldManager manager = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
            List customFieldGroupList = manager.getAllGroups();
            customFields.setCustomFieldGroups(customFieldGroupList);
        }
        catch (AuthorizationException ae) {
            throw ae;
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting custom fields : " + e));
            throw new RuntimeException(e);
        }
        finally {
            securityClient.logout();
        }
        logger.info((Object)"Finished exporting custom fields ");
        return customFields;
    }

    private static void setGroupId(List<CustomFieldGroup> customFieldGroups) {
        if (customFieldGroups != null) {
            for (CustomFieldGroup group : customFieldGroups) {
                List fieldList = group.getCustomFieldList();
                if (fieldList == null) continue;
                for (CustomField field : fieldList) {
                    field.setGroup(group);
                }
            }
        }
    }

    @Override
    public void customFieldsImport(boolean overwrite, CustomFields customFields) {
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            String userName = customFields.getUserName();
            String password = customFields.getPassword();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            String permission = CUSTOM_FIELDS_IMPORT;
            if (!Authorizer.hasPermission(permission, new String[0])) {
                throw new AuthorizationException("Caller is unauthorized to import custom fields.");
            }
            ICustomFieldManager manager = (ICustomFieldManager)ServiceRegistry.getDefault().lookup(ICustomFieldManager.class);
            List groupList = customFields.getCustomFieldGroups();
            if (groupList != null) {
                this.getRidOfIds(groupList);
                CustomFieldsService.setGroupId(groupList);
                manager.saveImportedCustomFields(groupList);
            }
        }
        catch (AuthorizationException ae) {
            throw ae;
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred importing custom fields : " + e));
            throw new RuntimeException(e);
        }
        finally {
            securityClient.logout();
        }
        logger.info((Object)"Finished importing custom fields ");
    }

    private void getRidOfIds(List<CustomFieldGroup> groupList) {
        for (CustomFieldGroup group : groupList) {
            group.setId(null);
            List cfList = group.getCustomFieldList();
            if (cfList == null) continue;
            for (CustomField cf : cfList) {
                cf.setId(null);
            }
        }
    }
}

