/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.cms.services.TimerHelper;
import java.util.Date;

public class Daily {
    private static long INTERVAL = 86400000L;
    private static String MIDNIGHT = "12:00 am";

    public static ScheduleTime getTime(ScheduleRule rule) {
        Date jobStartDate;
        String time = rule.getParam(4).getValue();
        if (time == null || time.trim().length() < 0) {
            time = MIDNIGHT;
        }
        Date startDate = rule.getStartDate();
        Date now = new Date();
        if (startDate == null || startDate.before(now)) {
            startDate = now;
        }
        if ((jobStartDate = TimerHelper.getStartDateTime(startDate, time)).before(now)) {
            long jobStartDateMillis = jobStartDate.getTime();
            jobStartDate.setTime(jobStartDateMillis += INTERVAL);
        }
        return new ScheduleTime(jobStartDate, rule.getEndDate(), INTERVAL);
    }
}

