/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.cms.services.TimerHelper;
import java.util.Date;
import org.apache.log4j.Logger;

public class EveryNDays {
    private static long MSEC_IN_ONE_DAY = 86400000L;
    private static final Logger logger = Logger.getLogger(EveryNDays.class);

    public static ScheduleTime getTime(ScheduleRule rule) {
        Date jobStartDate;
        String numberOfDays = rule.getParam(1).getValue();
        String jobTime = rule.getParam(2).getValue();
        if (numberOfDays == null) {
            logger.error((Object)"Number of days not specified");
            return null;
        }
        if (Integer.parseInt(numberOfDays) == 0) {
            logger.error((Object)"Number of days cannot be 0");
            return null;
        }
        Date startDate = rule.getStartDate();
        Date now = new Date();
        if (startDate == null || startDate.before(now)) {
            startDate = now;
        }
        if ((jobStartDate = TimerHelper.getStartDateTime(startDate, jobTime)).before(now)) {
            long jobStartDateMillis = jobStartDate.getTime();
            jobStartDate.setTime(jobStartDateMillis += MSEC_IN_ONE_DAY);
        }
        long periodicity = Long.parseLong(numberOfDays) * MSEC_IN_ONE_DAY;
        return new ScheduleTime(jobStartDate, rule.getEndDate(), periodicity);
    }
}

