/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.tandbergtv.cms.services.Day;
import com.tandbergtv.cms.services.EveryNWeeks;
import com.tandbergtv.cms.services.ScheduleTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class OnDayEveryNWeeks {
    private static final Logger logger = Logger.getLogger(OnDayEveryNWeeks.class);
    public static String DATE_FORMAT = "EEE MMM dd HH:mm:ss z yyyy";

    public static ScheduleTime getTime(ScheduleRule rule) {
        String day = rule.getParam(1).getValue();
        String numberOfWeeks = rule.getParam(2).getValue();
        String jobTime = rule.getParam(3).getValue();
        logger.debug((Object)("Initial job start date: " + rule.getStartDate()));
        Date startDate = rule.getStartDate();
        Date now = new Date();
        if (startDate == null || startDate.before(now)) {
            startDate = now;
        }
        Date jobStartDate = OnDayEveryNWeeks.getClosestDay(startDate, day);
        logger.debug((Object)("Setting job start date to: " + jobStartDate.toString()));
        return EveryNWeeks.getTime(jobStartDate, jobTime, numberOfWeeks, rule);
    }

    private static Date getClosestDay(Date startDate, String day) {
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        int startDay = c.get(7);
        int d = Day.valueOf(day).ordinal() + 1;
        if (startDay == d) {
            return startDate;
        }
        while (startDay != d) {
            c.add(5, 1);
            startDay = c.get(7);
        }
        return c.getTime();
    }
}

