/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Authorizer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;
import sun.misc.BASE64Decoder;

public class RESTAuthentication {
    private static final Logger logger = Logger.getLogger((String)RESTAuthentication.class.getName());
    private SecurityClient securityClient;
    private LoginInfo loginInfo;

    public RESTAuthentication(String authorizationHeader) {
        this.loginInfo = RESTAuthentication.getLoginInfoForAuthorizationHeader(authorizationHeader);
        this.securityClient = this.login(this.loginInfo);
    }

    public String getUsername() {
        if (this.loginInfo == null) {
            return null;
        }
        return this.loginInfo.getUsername();
    }

    public static RESTAuthentication loginIfHasAnyOfThePermissions(String authorizationHeader, String ... permissions) {
        RESTAuthentication result = new RESTAuthentication(authorizationHeader);
        if (!result.hasAnyPermission(permissions)) {
            throw new AuthorizationException("Caller is unauthorized to execute operation.");
        }
        return result;
    }

    private boolean hasAllPermissions(String ... permissions) {
        for (String p : permissions) {
            if (this.userHasPermission(p)) continue;
            return false;
        }
        return true;
    }

    private boolean userHasPermission(String p) {
        try {
            Authorizer.hasPermission(p, new String[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean hasAnyPermission(String ... permissions) {
        for (String p : permissions) {
            if (!this.userHasPermission(p)) continue;
            return true;
        }
        return false;
    }

    public static RESTAuthentication loginIfHasAllOfThePermissions(String authorizationHeader, String ... permissions) {
        RESTAuthentication result = new RESTAuthentication(authorizationHeader);
        if (!result.hasAllPermissions(permissions)) {
            throw new AuthorizationException("Caller is unauthorized to execute operation.");
        }
        return result;
    }

    private SecurityClient login(LoginInfo loginInfo) throws AuthorizationException {
        try {
            SecurityClient result = SecurityClientFactory.getSecurityClient();
            result.setSimple((Object)loginInfo.getUsername(), (Object)loginInfo.getPassword());
            result.login();
            return result;
        }
        catch (Exception e) {
            throw new AuthorizationException(e);
        }
    }

    private static LoginInfo getLoginInfoForAuthorizationHeader(String authorizationHeader) {
        if (authorizationHeader == null || !authorizationHeader.toUpperCase().startsWith("BASIC ")) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String decodedUsernameAndPassword = RESTAuthentication.decodeUsernameAndPassword(authorizationHeader);
        Pattern pattern = Pattern.compile(":.*$");
        Matcher matcher = pattern.matcher(decodedUsernameAndPassword);
        matcher.find();
        String username = decodedUsernameAndPassword.substring(0, matcher.start());
        String password = matcher.group().substring(1);
        return new LoginInfo(username, password);
    }

    private static String decodeUsernameAndPassword(String authorizationHeader) {
        try {
            BASE64Decoder base64Decoder = new BASE64Decoder();
            String encodedUsernameAndPassword = authorizationHeader.substring(6);
            String decodedUsernameAndPassword = new String(base64Decoder.decodeBuffer(encodedUsernameAndPassword));
            return decodedUsernameAndPassword;
        }
        catch (IOException e) {
            logger.error((Object)"Error trying to decode authentication header", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void logout() {
        this.securityClient.logout();
    }

    private static class LoginInfo {
        String username;
        String password;

        public LoginInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

