/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services;

import com.ericsson.cms.scheduler.InvalidScheduleException;
import com.ericsson.cms.scheduler.SchedulerException;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.tandbergtv.cms.data.RuleSetToSave;
import com.tandbergtv.cms.data.RuleSetsListing;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.rules.service.category.IPackageManager;
import com.tandbergtv.cms.rules.service.category.IRuleManager;
import com.tandbergtv.cms.services.AuthorizationException;
import com.tandbergtv.cms.services.Authorizer;
import com.tandbergtv.cms.services.Daily;
import com.tandbergtv.cms.services.EveryNDays;
import com.tandbergtv.cms.services.IRulesService;
import com.tandbergtv.cms.services.OnDate;
import com.tandbergtv.cms.services.OnDayEveryNWeeks;
import com.tandbergtv.cms.services.RulesServiceUtils;
import com.tandbergtv.cms.services.ScheduleExpiredException;
import com.tandbergtv.cms.services.ScheduleTime;
import com.tandbergtv.marvin.udt.TreMsoOverrrideRuleSet;
import com.tandbergtv.marvin.udt.TrePackage;
import com.tandbergtv.marvin.udt.TreRuleSet;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJBTransactionRolledbackException;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;

public class RulesService
implements IRulesService {
    private static final Logger logger = Logger.getLogger((String)RulesService.class.getName());
    private static final String RULES_MODULE_NAME = "RulesManagement";
    private static final String SITES_MODULE_NAME = "Sites";
    private static final String PERMISSION_EXPORT = "View";
    private static final String PERMISSION_IMPORT = "Create";
    private static final String PERMISSION_MODIFY = "Modify";
    private static final boolean DEFAULT_CHECK_SITE_PERMISSIONS_WHEN_IMPORTING = false;
    private static final int RULESET_ID_FOR_ALL = -101;
    private static final boolean ADD_DUMMY_RULESETS = false;
    private Set<TreRuleSet> rulesets = new HashSet<TreRuleSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response authenticate(String userName, String password) {
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            InitialContext ctx = new InitialContext();
            IRuleManager ruleManager = (IRuleManager)ctx.lookup("cms/RuleManagerImpl/local");
            ArrayList<Integer> ruleSetIds = new ArrayList<Integer>();
            ruleSetIds.add(0);
            this.getRuleSetsFromRuleManager(ruleManager, ruleSetIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting rule sets from RuleManager : " + e), (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("text/plain").build();
            return response;
        }
        finally {
            securityClient.logout();
        }
        return Response.status((Response.Status)Response.Status.OK).type("text/plain").build();
    }

    @Override
    public RuleSetsListing getRuleSets(String userName, String password, List<Integer> ruleSetIds) {
        return this.getRuleSetsListingWithLogin(userName, password, ruleSetIds);
    }

    @Override
    public RuleSetsListing getRuleSetsByUuid(String userName, String password, String uuid) {
        return this.getRuleSetsByUuidWithLogin(userName, password, uuid);
    }

    @Override
    public void saveRuleSet(boolean overwrite, RuleSetToSave ruleSetToSave) {
        String userName = ruleSetToSave.getUserName();
        String password = ruleSetToSave.getPassword();
        TreRuleSet treRuleSet = ruleSetToSave.getRuleSet();
        this.saveRuleSetWithLogin(userName, password, treRuleSet, overwrite);
    }

    private RuleSetsListing getRuleSetsListingWithLogin(String userName, String password, List<Integer> ruleSetIds) {
        ArrayList<TreRuleSet> treRuleSetsList = new ArrayList<TreRuleSet>();
        treRuleSetsList.addAll(this.rulesets);
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            String permission = PERMISSION_EXPORT;
            if (!Authorizer.hasPermission(RULES_MODULE_NAME, permission)) {
                throw new AuthorizationException("Caller is unauthorized to export rules.");
            }
            InitialContext ctx = new InitialContext();
            IRuleManager ruleManager = (IRuleManager)ctx.lookup("cms/RuleManagerImpl/local");
            treRuleSetsList.addAll(this.getRuleSetsFromRuleManager(ruleManager, ruleSetIds));
        }
        catch (AuthorizationException ae) {
            throw ae;
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting rule sets from RuleManager : " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            securityClient.logout();
        }
        logger.info((Object)("Finished getting ruleSets for ruleSetIds : " + ruleSetIds));
        RuleSetsListing ruleSetsListing = new RuleSetsListing(treRuleSetsList);
        return ruleSetsListing;
    }

    @Transactional
    private List<TreRuleSet> getRuleSetsFromRuleManager(IRuleManager ruleManager, List<Integer> ruleSetIds) {
        IRuleManager iRuleManager = ruleManager;
        List<Integer> list = ruleSetIds;
        return (List)RulesService.getRuleSetsFromRuleManager_aroundBody1$advice(this, iRuleManager, list, TransactionEnforcer.aspectOf(), RulesService.class.getDeclaredMethod("getRuleSetsFromRuleManager", IRuleManager.class, List.class).getAnnotation(Transactional.class), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleSetsListing getRuleSetsByUuidWithLogin(String userName, String password, String uuid) {
        ArrayList<TreRuleSet> treRuleSetsList = new ArrayList<TreRuleSet>();
        treRuleSetsList.addAll(this.rulesets);
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            InitialContext ctx = new InitialContext();
            IRuleManager ruleManager = (IRuleManager)ctx.lookup("cms/RuleManagerImpl/local");
            treRuleSetsList.addAll(this.getRuleSetsByUuidFromRuleManager(ruleManager, uuid));
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting rule sets from RuleManager : " + e), (Throwable)e);
        }
        finally {
            securityClient.logout();
        }
        logger.info((Object)("Finished getting ruleSets for uuid : " + uuid));
        RuleSetsListing ruleSetsListing = new RuleSetsListing(treRuleSetsList);
        return ruleSetsListing;
    }

    @Transactional
    private List<TreRuleSet> getRuleSetsByUuidFromRuleManager(IRuleManager ruleManager, String uuid) {
        IRuleManager iRuleManager = ruleManager;
        String string = uuid;
        return (List)RulesService.getRuleSetsByUuidFromRuleManager_aroundBody3$advice(this, iRuleManager, string, TransactionEnforcer.aspectOf(), RulesService.class.getDeclaredMethod("getRuleSetsByUuidFromRuleManager", IRuleManager.class, String.class).getAnnotation(Transactional.class), null);
    }

    private void saveRuleSetWithLogin(String userName, String password, TreRuleSet ruleSet, boolean overwrite) {
        logger.info((Object)("In saveRuleSetWithLogin with userName : " + userName + ", password : " + password + ", ruleSet : " + ruleSet + ", overwrite : " + overwrite));
        SecurityClient securityClient = null;
        try {
            securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple((Object)userName, (Object)password);
            securityClient.login();
            String permission = PERMISSION_IMPORT;
            if (!Authorizer.hasPermission(RULES_MODULE_NAME, permission)) {
                throw new AuthorizationException("Caller is unauthorized to import rules.");
            }
            InitialContext ctx = new InitialContext();
            IPackageManager packageManager = (IPackageManager)ctx.lookup("cms/PackageManagerImpl/local");
            IRuleManager ruleManager = (IRuleManager)ctx.lookup("cms/RuleManagerImpl/local");
            ISiteManager siteManager = (ISiteManager)ctx.lookup("cms/SiteManager/local");
            logger.info((Object)("Saving TreRuleSet with Package Manager : " + ruleSet));
            this.saveRuleSetWithPackageManager(packageManager, ruleManager, siteManager, ruleSet, overwrite);
            logger.info((Object)("Finished saving TreRuleSet with RuleManager : " + ruleSet));
        }
        catch (AuthorizationException ae) {
            throw ae;
        }
        catch (ScheduleExpiredException see) {
            throw see;
        }
        catch (EJBTransactionRolledbackException etre) {
            logger.warn((Object)"Exception occurred saving ruleSet with login : ", (Throwable)etre);
            Throwable cause = etre.getCause();
            if (cause instanceof InvalidScheduleException) {
                InvalidScheduleException ise = (InvalidScheduleException)cause;
                throw ise;
            }
            throw new RuntimeException(etre);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred saving ruleSet with login : " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            securityClient.logout();
        }
    }

    @Transactional
    private void saveRuleSetWithPackageManager(IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite) {
        IPackageManager iPackageManager = packageManager;
        IRuleManager iRuleManager = ruleManager;
        ISiteManager iSiteManager = siteManager;
        TreRuleSet treRuleSet = ruleSet;
        boolean bl = overwrite;
        RulesService.saveRuleSetWithPackageManager_aroundBody5$advice(this, iPackageManager, iRuleManager, iSiteManager, treRuleSet, bl, TransactionEnforcer.aspectOf(), RulesService.class.getDeclaredMethod("saveRuleSetWithPackageManager", IPackageManager.class, IRuleManager.class, ISiteManager.class, TreRuleSet.class, Boolean.TYPE).getAnnotation(Transactional.class), null);
    }

    private void updateMsos(TreMsoOverrrideRuleSet ruleSet) {
        IMSOManager msoManager = (IMSOManager)InjectionUtil.injectInstance((String)"cms/MSOManager/local", IMSOManager.class);
        HashSet<MSO> msosToSave = new HashSet<MSO>();
        Set dirtyMsos = ruleSet.getMsos();
        for (MSO dmso : dirtyMsos) {
            MSO mso = msoManager.getMSOByName(dmso.getMsoName());
            if (mso == null) {
                dmso.setId(null);
                mso = dmso;
                try {
                    msoManager.saveMSO(mso);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            msosToSave.add(mso);
        }
        ruleSet.setMsos(msosToSave);
    }

    private boolean hasExpiredSchedule(TreRuleSet ruleSet) {
        ScheduleRule scheduleRule;
        boolean hasExpiredSchedule = false;
        if (ruleSet != null && (scheduleRule = ruleSet.getScheduleRule()) != null) {
            Date endDate = scheduleRule.getEndDate();
            Date now = new Date();
            if (endDate != null && endDate.before(now)) {
                hasExpiredSchedule = true;
            }
        }
        return hasExpiredSchedule;
    }

    private ScheduleTime getScheduleTime(ScheduleRule rule) {
        switch (rule.getType()) {
            case ON_DATE: {
                return OnDate.getTime(rule);
            }
            case EVERY_N_DAYS: {
                return EveryNDays.getTime(rule);
            }
            case ON_DAY_EVERY_N_WEEKS: {
                return OnDayEveryNWeeks.getTime(rule);
            }
            case N_DAYS_FROM_METADATA: {
                return Daily.getTime(rule);
            }
        }
        throw new SchedulerException("Unknown Schedule Rule Type: " + rule.getType());
    }

    private static final /* synthetic */ List getRuleSetsFromRuleManager_aroundBody0(RulesService this_, IRuleManager ruleManager, List ruleSetIds) {
        logger.info((Object)("Getting ruleSets from RuleManager for ruleSetIds : " + ruleSetIds));
        List treRuleSets = new ArrayList();
        if (ruleSetIds.contains(-101)) {
            logger.info((Object)"Getting ALL ruleSets in the system...");
            for (String packType : TrePackage.RULE_TYPES) {
                treRuleSets.addAll(ruleManager.getRuleSetsByPackageWithSchedule(packType));
            }
        } else {
            treRuleSets = ruleManager.getRuleSetsWithSchedule(ruleSetIds);
        }
        for (TreRuleSet treRuleSet : treRuleSets) {
            RulesServiceUtils.initializeRuleSet(treRuleSet);
        }
        logger.info((Object)("Finished getting ruleSets from RuleManager for ruleSetIds : " + ruleSetIds));
        return treRuleSets;
    }

    private static final /* synthetic */ Object getRuleSetsFromRuleManager_aroundBody1$advice(RulesService this_, IRuleManager ruleManager, List ruleSetIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesService.getRuleSetsFromRuleManager_aroundBody0(this_, ruleManager, ruleSetIds);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesService.getRuleSetsFromRuleManager_aroundBody0(this_, ruleManager, ruleSetIds);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getRuleSetsByUuidFromRuleManager_aroundBody2(RulesService this_, IRuleManager ruleManager, String uuid) {
        logger.info((Object)("Getting ruleSets from RuleManager for uuid : " + uuid));
        List treRuleSets = ruleManager.getRuleSetsByUuid(uuid);
        for (TreRuleSet treRuleSet : treRuleSets) {
            RulesServiceUtils.initializeRuleSet(treRuleSet);
        }
        logger.info((Object)("Finished getting ruleSets from RuleManager for uuid : " + uuid));
        return treRuleSets;
    }

    private static final /* synthetic */ Object getRuleSetsByUuidFromRuleManager_aroundBody3$advice(RulesService this_, IRuleManager ruleManager, String uuid, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return RulesService.getRuleSetsByUuidFromRuleManager_aroundBody2(this_, ruleManager, uuid);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = RulesService.getRuleSetsByUuidFromRuleManager_aroundBody2(this_, ruleManager, uuid);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveRuleSetWithPackageManager_aroundBody4(RulesService this_, IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite) {
        List<TreRuleSet> ruleSets;
        int numRuleSets;
        logger.info((Object)("Saving TreRuleSet with PackageManager : " + ruleSet + ", overwrite : " + overwrite));
        boolean hasExpiredSchedule = this_.hasExpiredSchedule(ruleSet);
        if (hasExpiredSchedule) {
            throw new ScheduleExpiredException("Ruleset is schedulable but it's schedule has expired.");
        }
        UUID uuid = ruleSet.getUuid();
        boolean foundRuleSetWithUuid = false;
        TreRuleSet origRuleSetWithSameUuid = null;
        String packageName = ruleSet.getTpackage().getName().trim();
        logger.debug((Object)("Got packageName : " + packageName));
        logger.debug((Object)("Cleansing ruleSet : " + ruleSet));
        ruleSet = RulesServiceUtils.cleanseRuleSet(ruleSet);
        if (packageName.equals("MSOOVERRIDE")) {
            this_.updateMsos((TreMsoOverrrideRuleSet)ruleSet);
        }
        Set importingSites = ruleSet.getSites();
        logger.debug((Object)("Got importingSites : " + importingSites));
        HashSet<LogicalSite> filteredImportingSites = new HashSet<LogicalSite>();
        for (Site importingSite : importingSites) {
            String importingSiteName = importingSite.getName();
            SiteType importingSiteType = importingSite.getType();
            Site targetSystemSite = siteManager.getSiteByName(importingSiteName);
            logger.debug((Object)("Got targetSystemSite : " + targetSystemSite + " for importingSiteName : " + importingSiteName));
            if (targetSystemSite != null) {
                SiteType targetSystemSiteType = targetSystemSite.getType();
                if (targetSystemSiteType.equals((Object)importingSiteType)) {
                    LogicalSite s = null;
                    if (SiteType.LOGICAL.equals((Object)targetSystemSiteType)) {
                        s = new LogicalSite();
                    } else if (SiteType.DISTRIBUTION.equals((Object)targetSystemSiteType)) {
                        s = new DistributionSite();
                    }
                    if (s == null) continue;
                    s.setId(targetSystemSite.getId());
                    filteredImportingSites.add(s);
                    continue;
                }
                logger.warn((Object)("targetSystemSiteType differs from importingSiteType. Site will not be associated with Rule Set being imported. importingSite : " + importingSite + ", targetSystemSite : " + targetSystemSite));
                continue;
            }
            logger.debug((Object)("No target system site found for importingSiteName : " + importingSiteName));
        }
        logger.debug((Object)("Got filteredImportingSites : " + filteredImportingSites));
        ruleSet.getSites().clear();
        ruleSet.getSites().addAll(filteredImportingSites);
        int numFilteredImportingSites = filteredImportingSites.size();
        String permission = PERMISSION_MODIFY;
        boolean checkSitesPermissions = false;
        if (checkSitesPermissions && numFilteredImportingSites > 0 && !Authorizer.hasPermission(SITES_MODULE_NAME, permission)) {
            throw new AuthorizationException("The importing ruleSet is associated with a site, while the caller does not have permissions to modify Site.");
        }
        ScheduleRule scheduleRule = ruleSet.getScheduleRule();
        if (scheduleRule != null) {
            Date startDate = scheduleRule.getStartDate();
            Date endDate = scheduleRule.getEndDate();
            Date now = new Date();
            if ((endDate == null || endDate.after(now)) && startDate != null && startDate.before(now)) {
                ScheduleTime scheduleTime = this_.getScheduleTime(scheduleRule);
                logger.debug((Object)("scheduleTime.getStartDate() : " + scheduleTime.getStartDate()));
                logger.debug((Object)("scheduleTime.getEndDate() : " + scheduleTime.getEndDate()));
                logger.debug((Object)("scheduleTime.getRepeatInterval() : " + scheduleTime.getRepeatInterval()));
                scheduleRule.setStartDate(scheduleTime.getStartDate());
            }
        }
        if (overwrite && uuid != null && (numRuleSets = (ruleSets = this_.getRuleSetsByUuidFromRuleManager(ruleManager, uuid.toString())).size()) > 0) {
            foundRuleSetWithUuid = true;
            origRuleSetWithSameUuid = ruleSets.get(0);
        }
        try {
            TrePackage pack = packageManager.getPackageByNameFirstMatching(packageName);
            if (foundRuleSetWithUuid) {
                for (TreRuleSet pRuleSet : pack.getRuleSets()) {
                    if (!uuid.toString().equalsIgnoreCase(pRuleSet.getUuid().toString())) continue;
                    origRuleSetWithSameUuid = pRuleSet;
                    TreRuleSet copiedRuleSet = RulesServiceUtils.copyRuleSetDetails(origRuleSetWithSameUuid, ruleSet);
                    logger.debug((Object)("Got copiedRuleSet : " + copiedRuleSet));
                    ruleManager.saveRuleSet(copiedRuleSet);
                }
            } else {
                pack.getRuleSets().add(ruleSet);
                ruleSet.setTpackage(pack);
                ruleSet.setOrder_(Integer.valueOf(pack.getRuleSets().size() - 1));
                ruleManager.saveRuleSet(ruleSet);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Exception occurred adding/updating ruleSet : " + ruleSet + " : " + e), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred adding/updating ruleSet : " + ruleSet + " : " + e), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static final /* synthetic */ Object saveRuleSetWithPackageManager_aroundBody5$advice(RulesService this_, IPackageManager packageManager, IRuleManager ruleManager, ISiteManager siteManager, TreRuleSet ruleSet, boolean overwrite, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            RulesService.saveRuleSetWithPackageManager_aroundBody4(this_, packageManager, ruleManager, siteManager, ruleSet, overwrite);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            RulesService.saveRuleSetWithPackageManager_aroundBody4(this_, packageManager, ruleManager, siteManager, ruleSet, overwrite);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

