/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.mso;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.mediapath.MSO;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.ericsson.cms.sites.core.mediapath.IMSOManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.cms.services.mso.IMSOService;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.resources.Mso;
import com.tandbergtv.cms.services.resources.ResourceList;
import com.tandbergtv.cms.services.resources.Site;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class MSOService
implements IMSOService {
    private static final String PERMISSION_SITES_CREATE = "Sites_Create";
    private static final String PERMISSION_SITES_UPDATE = "Sites_Modify";
    private static final String PERMISSION_SITES_VIEW = "Sites_View";
    private static final String PERMISSION_SITES_DELETE = "Sites_Delete";
    private IMSOManager msoManager = (IMSOManager)InjectionUtil.injectInstance((String)"cms/MSOManager/local", IMSOManager.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response createMSO(String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, Mso metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        RESTAuthentication auth = null;
        if (contentType == null) {
            errors.getErrors().add("Content type not specified");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
                try {
                    mso = this.convertMso(metadata);
                    this.msoManager.saveMSO(mso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)this.convertMSO(mso, uriInfo)).type(contentType);
            }
        }
        return builder.build();
    }

    private MSO convertMso(Mso mso) {
        MSO response = new MSO();
        if (mso.getName() != null) {
            response.setMsoName(mso.getName());
        }
        if (mso.getDescription() != null) {
            response.setMsoDescription(mso.getDescription());
        }
        return response;
    }

    @Override
    @Transactional
    public Response deleteMSO(String authorizationHeader, String contentType, String msoId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)MSOService.deleteMSO_aroundBody1$advice(this, string, string2, string3, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("deleteMSO", String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response getAssociatedSites(String authorizationHeader, String contentType, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = msoId;
        Date date = expires;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)MSOService.getAssociatedSites_aroundBody3$advice(this, string, string2, string3, date, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("getAssociatedSites", String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response getMSO(String authorizationHeader, String contentType, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = msoId;
        Date date = lastModified;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)MSOService.getMSO_aroundBody5$advice(this, string, string2, string3, date, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("getMSO", String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    private Mso convertMSO(MSO mso, UriInfo request) {
        Mso response = new Mso();
        response.setDescription(mso.getMsoDescription());
        response.setName(mso.getMsoName());
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(0) + slash + mso.getId();
        response.setHref(href);
        return response;
    }

    private Mso convertMsoSlashEnd(MSO mso, UriInfo request) {
        Mso response = new Mso();
        response.setDescription(mso.getMsoDescription());
        response.setName(mso.getMsoName());
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(0) + slash;
        response.setHref(href);
        return response;
    }

    @Override
    @Transactional
    public Response updateMSO(String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso) {
        String string = authorizationHeader;
        String string2 = contentType;
        Date date = lastModified;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        Mso mso2 = mso;
        return (Response)MSOService.updateMSO_aroundBody7$advice(this, string, string2, date, string3, request2, uriInfo2, securityContext, mso2, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("updateMSO", String.class, String.class, Date.class, String.class, Request.class, UriInfo.class, SecurityContext.class, Mso.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response updateMSO(String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        String string = authorizationHeader;
        String string2 = contentType;
        Date date = lastModified;
        String string3 = msoId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        String string4 = jsonString;
        return (Response)MSOService.updateMSO_aroundBody9$advice(this, string, string2, date, string3, request2, uriInfo2, securityContext, string4, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("updateMSO", String.class, String.class, Date.class, String.class, Request.class, UriInfo.class, SecurityContext.class, String.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response associateSite(String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = msoId;
        String string4 = siteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)MSOService.associateSite_aroundBody11$advice(this, string, string2, string3, string4, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("associateSite", String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response deleteSiteAssociation(String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = msoId;
        String string4 = siteId;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)MSOService.deleteSiteAssociation_aroundBody13$advice(this, string, string2, string3, string4, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), MSOService.class.getDeclaredMethod("deleteSiteAssociation", String.class, String.class, String.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getList(String authorizationHeader, Date expires, String contentType, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        ResourceList list = new ResourceList();
        RESTAuthentication auth = null;
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_VIEW);
            List msoList = this.msoManager.getAllMSOs();
            for (MSO mso : msoList) {
                list.getMsos().add(this.convertMSO(mso, uriInfo));
            }
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
            builder = Response.ok((Object)list).type(contentType);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getSite(String authorizationHeader, String contentType, String siteName, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        Errors errors;
        Response.ResponseBuilder builder;
        block11: {
            block10: {
                com.ericsson.cms.sites.core.entities.Site site = null;
                Site resp = null;
                builder = null;
                errors = new Errors();
                RESTAuthentication auth = null;
                try {
                    auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_VIEW);
                    try {
                        site = this.siteManager.getSiteByName(siteName);
                        resp = this.convertSite(site, uriInfo);
                    }
                    catch (Exception e) {
                        errors.getErrors().add(e.getLocalizedMessage());
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    if (auth != null) {
                        auth.logout();
                    }
                    if (site == null) break block10;
                }
                catch (Throwable throwable) {
                    if (auth != null) {
                        auth.logout();
                    }
                    if (site != null) {
                        builder = Response.ok(resp).type(contentType);
                    } else {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                    }
                    if (errors.getErrors().size() > 0) {
                        builder.entity((Object)errors);
                    }
                    throw throwable;
                }
                builder = Response.ok((Object)resp).type(contentType);
                break block11;
            }
            errors.getErrors().add("Site not found");
            builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
        }
        if (errors.getErrors().size() > 0) {
            builder.entity((Object)errors);
        }
        return builder.build();
    }

    private Site convertSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        Site response = new Site();
        response.setName(site.getName());
        String href = request.getBaseUri() + request.getPath().substring(0) + "/" + site.getId();
        response.setHref(href);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response createMSO(String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        Mso serviceMso = null;
        ObjectMapper mapper = new ObjectMapper();
        RESTAuthentication auth = null;
        String jsonResponse = "";
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
            if (contentType == null) {
                errors.getErrors().add("Content type not specified");
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            } else {
                try {
                    serviceMso = (Mso)mapper.readValue(jsonString, Mso.class);
                    mso = this.convertMso(serviceMso);
                    this.msoManager.saveMSO(mso);
                    Mso responseMso = this.convertMSO(mso, uriInfo);
                    mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                    jsonResponse = mapper.writeValueAsString((Object)responseMso);
                    builder = Response.ok((Object)jsonResponse).type(contentType);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)jsonResponse).type(contentType);
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response deleteMSO_aroundBody0(MSOService this_, String authorizationHeader, String contentType, String msoId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder;
        block9: {
            builder = null;
            Errors errors = new Errors();
            MSO mso = null;
            RESTAuthentication auth = null;
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_DELETE, PERMISSION_SITES_UPDATE);
                try {
                    mso = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (mso == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block9;
                    }
                    this_.msoManager.deleteMSO(mso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
                if (errors.getErrors().size() > 0) {
                    builder.entity((Object)errors);
                } else {
                    builder = Response.ok((Object)"MSO has been deleted").type(contentType);
                }
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object deleteMSO_aroundBody1$advice(MSOService this_, String authorizationHeader, String contentType, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.deleteMSO_aroundBody0(this_, authorizationHeader, contentType, msoId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.deleteMSO_aroundBody0(this_, authorizationHeader, contentType, msoId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response getAssociatedSites_aroundBody2(MSOService this_, String authorizationHeader, String contentType, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO mso = null;
        Object sites = null;
        ResourceList resourceList = new ResourceList();
        String slash = "/";
        if (uriInfo.getPath().endsWith("/")) {
            slash = "";
        }
        RESTAuthentication auth = null;
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
            try {
                mso = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                if (mso == null) {
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                } else {
                    for (MediapathDistributionSite site : mso.getMediaPathSiteSet()) {
                        Site siteResponse = new Site();
                        siteResponse.setName(site.getName());
                        siteResponse.setHref(uriInfo.getPath() + slash + site.getId());
                        resourceList.getSites().add(siteResponse);
                    }
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)resourceList).type(contentType);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getAssociatedSites_aroundBody3$advice(MSOService this_, String authorizationHeader, String contentType, String msoId, Date expires, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.getAssociatedSites_aroundBody2(this_, authorizationHeader, contentType, msoId, expires, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.getAssociatedSites_aroundBody2(this_, authorizationHeader, contentType, msoId, expires, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response getMSO_aroundBody4(MSOService this_, String authorizationHeader, String contentType, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        MSO mso = null;
        Mso resp = null;
        ObjectMapper mapper = new ObjectMapper();
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        String jsonResponse = "";
        RESTAuthentication auth = null;
        if (contentType == null) {
            errors.getErrors().add("Content type not specified");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            block11: {
                try {
                    auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_VIEW);
                    try {
                        mso = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                        if (mso != null) {
                            resp = this_.convertMsoSlashEnd(mso, uriInfo);
                            builder = Response.ok((Object)resp).type(contentType);
                            break block11;
                        }
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                    }
                    catch (NumberFormatException e) {
                        errors.getErrors().add("Invalid msoId");
                        builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    }
                    catch (Exception e) {
                        errors.getErrors().add(e.getLocalizedMessage());
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
                finally {
                    if (auth != null) {
                        auth.logout();
                    }
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getMSO_aroundBody5$advice(MSOService this_, String authorizationHeader, String contentType, String msoId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.getMSO_aroundBody4(this_, authorizationHeader, contentType, msoId, lastModified, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.getMSO_aroundBody4(this_, authorizationHeader, contentType, msoId, lastModified, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response updateMSO_aroundBody6(MSOService this_, String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        MSO msoObj = null;
        RESTAuthentication auth = null;
        if (contentType == null) {
            errors.getErrors().add("Content type not specified");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_UPDATE);
                msoObj = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                if (msoObj == null) {
                    errors.getErrors().add("MSO not found");
                    builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                } else {
                    if (mso.getDescription() != null) {
                        msoObj.setMsoDescription(mso.getDescription());
                    }
                    if (mso.getName() != null) {
                        msoObj.setMsoName(mso.getName());
                    }
                    this_.msoManager.saveMSO(msoObj);
                }
            }
            catch (Exception e) {
                errors.getErrors().add(e.getLocalizedMessage());
                builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)this_.convertMsoSlashEnd(msoObj, uriInfo)).type(contentType);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object updateMSO_aroundBody7$advice(MSOService this_, String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, Mso mso, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.updateMSO_aroundBody6(this_, authorizationHeader, contentType, lastModified, msoId, request, uriInfo, sec, mso);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.updateMSO_aroundBody6(this_, authorizationHeader, contentType, lastModified, msoId, request, uriInfo, sec, mso);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response updateMSO_aroundBody8(MSOService this_, String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        Response.ResponseBuilder builder;
        block11: {
            builder = null;
            Errors errors = new Errors();
            MSO msoObj = null;
            Mso serviceMso = null;
            ObjectMapper mapper = new ObjectMapper();
            RESTAuthentication auth = null;
            String jsonResponse = "";
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_UPDATE);
                try {
                    msoObj = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (msoObj == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block11;
                    }
                    serviceMso = (Mso)mapper.readValue(jsonString, Mso.class);
                    if (serviceMso.getDescription() != null) {
                        msoObj.setMsoDescription(serviceMso.getDescription());
                    }
                    if (serviceMso.getName() != null) {
                        msoObj.setMsoName(serviceMso.getName());
                    }
                    this_.msoManager.saveMSO(msoObj);
                    Mso responseMso = this_.convertMsoSlashEnd(msoObj, uriInfo);
                    mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                    jsonResponse = mapper.writeValueAsString((Object)responseMso);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
                if (errors.getErrors().size() > 0) {
                    builder.entity((Object)errors);
                } else {
                    builder = Response.ok((Object)jsonResponse).type(contentType);
                }
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object updateMSO_aroundBody9$advice(MSOService this_, String authorizationHeader, String contentType, Date lastModified, String msoId, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.updateMSO_aroundBody8(this_, authorizationHeader, contentType, lastModified, msoId, request, uriInfo, sec, jsonString);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.updateMSO_aroundBody8(this_, authorizationHeader, contentType, lastModified, msoId, request, uriInfo, sec, jsonString);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response associateSite_aroundBody10(MSOService this_, String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder;
        block10: {
            builder = null;
            Errors errors = new Errors();
            MSO mso = null;
            MediapathDistributionSite site = null;
            ResourceList resourceList = new ResourceList();
            RESTAuthentication auth = null;
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_UPDATE);
                try {
                    mso = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (mso == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    site = (MediapathDistributionSite)this_.siteManager.getSite(new Integer(siteId).intValue());
                    if (site == null) {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    mso.getMediaPathSiteSet().add(site);
                    this_.msoManager.saveMSO(mso);
                    resourceList.getMsos().add(this_.convertMsoSlashEnd(mso, uriInfo));
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
                if (errors.getErrors().size() > 0) {
                    builder.entity((Object)errors);
                } else {
                    builder = Response.ok((Object)resourceList).type(contentType);
                }
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object associateSite_aroundBody11$advice(MSOService this_, String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.associateSite_aroundBody10(this_, authorizationHeader, contentType, msoId, siteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.associateSite_aroundBody10(this_, authorizationHeader, contentType, msoId, siteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response deleteSiteAssociation_aroundBody12(MSOService this_, String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder;
        block10: {
            builder = null;
            Errors errors = new Errors();
            MSO mso = null;
            MediapathDistributionSite site = null;
            ResourceList resourceList = new ResourceList();
            RESTAuthentication auth = null;
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_UPDATE, PERMISSION_SITES_DELETE);
                try {
                    mso = this_.msoManager.getMSOById(new Integer(msoId).intValue());
                    if (mso == null) {
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    site = (MediapathDistributionSite)this_.siteManager.getSite(new Integer(siteId).intValue());
                    if (site == null) {
                        errors.getErrors().add("Site not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                        break block10;
                    }
                    mso.getMediaPathSiteSet().remove(site);
                    this_.msoManager.saveMSO(mso);
                    resourceList.getMsos().add(this_.convertMsoSlashEnd(mso, uriInfo));
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
                if (errors.getErrors().size() > 0) {
                    builder.entity((Object)errors);
                } else {
                    builder = Response.ok((Object)resourceList).type(contentType);
                }
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object deleteSiteAssociation_aroundBody13$advice(MSOService this_, String authorizationHeader, String contentType, String msoId, String siteId, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return MSOService.deleteSiteAssociation_aroundBody12(this_, authorizationHeader, contentType, msoId, siteId, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = MSOService.deleteSiteAssociation_aroundBody12(this_, authorizationHeader, contentType, msoId, siteId, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

