/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.site;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.ISitePartnerManager;
import com.ericsson.cms.sites.core.entities.Contact;
import com.ericsson.cms.sites.core.entities.DistributionOption;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.cms.sites.core.entities.LogicalSite;
import com.ericsson.cms.sites.core.entities.Property;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.core.entities.mediapath.MediapathDistributionSite;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.cms.services.resources.DistributionSite;
import com.tandbergtv.cms.services.resources.Errors;
import com.tandbergtv.cms.services.resources.LookupKeysType;
import com.tandbergtv.cms.services.resources.MediapathSite;
import com.tandbergtv.cms.services.resources.Partner;
import com.tandbergtv.cms.services.resources.ResourceList;
import com.tandbergtv.cms.services.resources.Site;
import com.tandbergtv.cms.services.resources.TrackingSite;
import com.tandbergtv.cms.services.site.ISiteService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import org.aspectj.runtime.internal.AroundClosure;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jettison.json.JSONObject;

public class SiteService
implements ISiteService {
    private static final String PERMISSION_SITES_CREATE = "Sites_Create";
    private static final String PERMISSION_SITES_UPDATE = "Sites_Modify";
    private static final String PERMISSION_SITES_VIEW = "Sites_View";
    private static final String PERMISSION_SITES_DELETE = "Sites_Delete";
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private ISitePartnerManager sitePartnerManager = (ISitePartnerManager)InjectionUtil.injectInstance((String)"cms/SitePartnerManager/local", ISitePartnerManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response createSite(String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, String jsonString) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        Site site = null;
        com.ericsson.cms.sites.core.entities.Site siteTosave = null;
        ObjectMapper mapper = new ObjectMapper();
        RESTAuthentication auth = null;
        String jsonResponse = "";
        String siteType = null;
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
            if (contentType == null) {
                errors.getErrors().add("Content type not specified");
                builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            } else {
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
                    mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    JSONObject obj = new JSONObject(jsonString);
                    if (obj.getString("@type").contains("Distribution")) {
                        site = (Site)mapper.readValue(jsonString, com.tandbergtv.cms.services.resources.DistributionSite.class);
                    }
                    siteTosave = this.convertSite(site, siteType);
                    this.siteManager.save(siteTosave);
                    this.setPartner(siteTosave, site);
                    Site responseSite = this.convertResponseSite(siteTosave, uriInfo);
                    mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                    jsonResponse = mapper.writeValueAsString((Object)responseSite);
                    builder = Response.ok((Object)jsonResponse).type(contentType);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)jsonResponse).type(contentType);
            }
        }
        return builder.build();
    }

    private com.ericsson.cms.sites.core.entities.Site convertSite(Site site, String siteType) {
        return null;
    }

    private Site convertResponseSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo request) {
        Site siteTo = this.convertFromBackendSite(site, request);
        String slash = "/";
        if (request.getPath().endsWith("/")) {
            slash = "";
        }
        String href = request.getBaseUri() + request.getPath().substring(0) + slash + site.getId();
        siteTo.setHref(href);
        return siteTo;
    }

    @Override
    @Transactional
    public Response getList(String authorizationHeader, Date expires, String contentType, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        Date date = expires;
        String string2 = contentType;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)SiteService.getList_aroundBody1$advice(this, string, date, string2, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), SiteService.class.getDeclaredMethod("getList", String.class, Date.class, String.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public Response createSite(String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, Site metadata) {
        String string = authorizationHeader;
        String string2 = contentType;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        Site site = metadata;
        return (Response)SiteService.createSite_aroundBody3$advice(this, string, string2, request2, uriInfo2, securityContext, site, TransactionEnforcer.aspectOf(), SiteService.class.getDeclaredMethod("createSite", String.class, String.class, Request.class, UriInfo.class, SecurityContext.class, Site.class).getAnnotation(Transactional.class), null);
    }

    private Site convertFromBackendSite(com.ericsson.cms.sites.core.entities.Site site, UriInfo uriInfo) {
        Site siteTo = null;
        if (site instanceof MediapathDistributionSite) {
            siteTo = this.convertMediapathDistributionFromBackEndSite(site);
        } else if (site instanceof DistributionSite) {
            siteTo = this.convertDistributionFromBackendSite(site);
        } else if (site instanceof LogicalSite) {
            siteTo = this.convertLogicalSiteFromBackEndSite((LogicalSite)site);
        } else if (site instanceof com.ericsson.cms.sites.core.entities.TrackingSite) {
            siteTo = new TrackingSite();
            if (((com.ericsson.cms.sites.core.entities.TrackingSite)site).getAlertDelayPeriod() != null) {
                ((TrackingSite)siteTo).setAllertDelayPeriod(((com.ericsson.cms.sites.core.entities.TrackingSite)site).getAlertDelayPeriod().toString());
            }
        } else {
            siteTo = new Site();
        }
        siteTo.setName(site.getName());
        siteTo.setExternalID(site.getExternalId());
        siteTo.setDescription(site.getDescription());
        this.updateSitePartnerFromBackend(siteTo, site.getId());
        return siteTo;
    }

    private void updateSitePartnerFromBackend(Site siteTo, Integer id) {
        SitePartner sitePartner = this.sitePartnerManager.get(id.intValue());
        if (sitePartner != null) {
            Partner p = new Partner();
            p.setContextId(String.valueOf(sitePartner.getContextId()));
            p.setProviderId(sitePartner.getProviderId());
            p.setLookupKey(sitePartner.getLookupKey());
            p.setFirstName(sitePartner.getContact().getFirstName());
            p.setLastName(sitePartner.getContact().getLastName());
            p.setEmail(sitePartner.getContact().getEmail());
            p.setProperties(this.convertPropertiesFromBackend(sitePartner.getProperties()));
            siteTo.setPartner(p);
        }
    }

    private Partner.Properties convertPropertiesFromBackend(List<Property> properties) {
        Partner.Properties props = new Partner.Properties();
        if (properties != null) {
            for (Property p : properties) {
                Partner.Properties.Entry e = new Partner.Properties.Entry();
                e.setKey(p.getName());
                e.setValue(p.getValue());
                props.getEntries().add(e);
            }
        }
        return props;
    }

    private com.ericsson.cms.sites.core.entities.Site convertSite(Site fromSite) {
        com.ericsson.cms.sites.core.entities.Site siteTo = null;
        if (fromSite instanceof MediapathSite) {
            siteTo = this.convertMadiapathSite(fromSite);
        } else if (fromSite instanceof com.tandbergtv.cms.services.resources.DistributionSite) {
            siteTo = this.convertDistributionSite(fromSite);
        } else if (fromSite instanceof com.tandbergtv.cms.services.resources.LogicalSite) {
            siteTo = this.convertLogicalSite(fromSite);
        } else if (fromSite instanceof TrackingSite) {
            siteTo = this.convertTrackingSite(fromSite);
        }
        if (siteTo != null) {
            siteTo.setName(fromSite.getName());
            siteTo.setExternalId(fromSite.getExternalID());
            siteTo.setDescription(fromSite.getDescription());
        }
        return siteTo;
    }

    private void setPartner(com.ericsson.cms.sites.core.entities.Site siteTo, Site fromSite) {
        SitePartner partner = new SitePartner();
        if (fromSite.getPartner() != null) {
            partner.setProviderId(fromSite.getPartner().getProviderId());
            partner.setLookupKey(fromSite.getPartner().getLookupKey());
            Contact contact = new Contact();
            contact.setFirstName(fromSite.getPartner().getFirstName());
            contact.setLastName(fromSite.getPartner().getLastName());
            contact.setEmail(fromSite.getPartner().getEmail());
            partner.setContact(contact);
            partner.setProperties(this.convertPartnerProperties(fromSite.getPartner().getProperties()));
            this.sitePartnerManager.createPartnerForSite(siteTo.getId().intValue(), partner);
        }
    }

    private List<Property> convertPartnerProperties(Partner.Properties properties) {
        List<Partner.Properties.Entry> list;
        ArrayList<Property> cpList = new ArrayList<Property>();
        if (properties != null && (list = properties.getEntries()) != null) {
            for (Partner.Properties.Entry entry : list) {
                Property p = new Property(entry.getKey(), entry.getValue());
                cpList.add(p);
            }
        }
        return cpList;
    }

    private com.ericsson.cms.sites.core.entities.Site convertMadiapathSite(Site fromSite) {
        MediapathDistributionSite siteTo = new MediapathDistributionSite();
        siteTo.setMetadataFormat(((MediapathSite)fromSite).getMetadataFormat());
        siteTo.setDistributionOption(DistributionOption.valueOf((String)((MediapathSite)fromSite).getDistributionOption()));
        siteTo.setAssociatedGroupName(((MediapathSite)fromSite).getAssociatedGroup());
        siteTo.setDistConfParams(this.convertDistParams(((MediapathSite)fromSite).getDistConfParams()));
        siteTo.setExportPluginName(((MediapathSite)fromSite).getExportConfiguration());
        siteTo.setExportConfParams(this.convertConfParams(((MediapathSite)fromSite).getExportConfParams()));
        if (((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAssociatedResource() != null) {
            siteTo.setAssociatedResourceId(Long.valueOf(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAssociatedResource()));
        }
        siteTo.setAlertDelayPeriod(Integer.valueOf(((MediapathSite)fromSite).getAllertDelayPeriod()));
        if (((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getLookupKeys() != null) {
            siteTo.setFileLookupKeys(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getLookupKeys().getLookupKeies());
        }
        siteTo.setDistTemplateName(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getDistributionConfiguration());
        return siteTo;
    }

    private com.ericsson.cms.sites.core.entities.Site convertTrackingSite(Site fromSite) {
        com.ericsson.cms.sites.core.entities.TrackingSite siteTo = new com.ericsson.cms.sites.core.entities.TrackingSite();
        siteTo.setAlertDelayPeriod(Integer.valueOf(((TrackingSite)fromSite).getAllertDelayPeriod()));
        return null;
    }

    private com.ericsson.cms.sites.core.entities.Site convertLogicalSite(Site fromSite) {
        LogicalSite siteTo = new LogicalSite();
        return siteTo;
    }

    private DistributionSite convertDistributionSite(Site fromSite) {
        DistributionSite siteTo = new DistributionSite();
        siteTo.setMetadataFormat(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getMetadataFormat());
        siteTo.setDistributionOption(DistributionOption.valueOf((String)((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getDistributionOption()));
        siteTo.setAssociatedGroupName(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAssociatedGroup());
        siteTo.setDistConfParams(this.convertDistParams(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getDistConfParams()));
        siteTo.setExportPluginName(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getExportConfiguration());
        siteTo.setExportConfParams(this.convertConfParams(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getExportConfParams()));
        if (((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAssociatedResource() != null) {
            siteTo.setAssociatedResourceId(Long.valueOf(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAssociatedResource()));
        }
        siteTo.setAlertDelayPeriod(Integer.valueOf(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getAllertDelayPeriod()));
        if (((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getLookupKeys() != null) {
            siteTo.setFileLookupKeys(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getLookupKeys().getLookupKeies());
        }
        siteTo.setDistTemplateName(((com.tandbergtv.cms.services.resources.DistributionSite)fromSite).getDistributionConfiguration());
        return siteTo;
    }

    private Site convertDistributionFromBackendSite(com.ericsson.cms.sites.core.entities.Site site) {
        com.tandbergtv.cms.services.resources.DistributionSite siteTo = new com.tandbergtv.cms.services.resources.DistributionSite();
        siteTo.setMetadataFormat(((DistributionSite)site).getMetadataFormat());
        siteTo.setDistributionOption(((DistributionSite)site).getDistributionOption().toString());
        siteTo.setAssociatedGroup(((DistributionSite)site).getAssociatedGroupName());
        siteTo.setDistConfParams(this.getDistConfParams(((DistributionSite)site).getDistConfParams()));
        siteTo.setExportConfiguration(((DistributionSite)site).getExportPluginName());
        if (((DistributionSite)site).getAlertDelayPeriod() != null) {
            siteTo.setAllertDelayPeriod(((DistributionSite)site).getAlertDelayPeriod().toString());
        }
        siteTo.setExportConfParams(this.getExportConfParams(((DistributionSite)site).getExportConfParams()));
        if (((DistributionSite)site).getAssociatedResourceId() != null) {
            siteTo.setAssociatedResource(((DistributionSite)site).getAssociatedResourceId().toString());
        }
        if (((DistributionSite)site).getFileLookupKeys() != null) {
            this.addLookUpKeysFromBackend(siteTo, ((DistributionSite)site).getFileLookupKeys());
        }
        siteTo.setDistributionConfiguration(((DistributionSite)site).getDistTemplateName());
        return siteTo;
    }

    private void addLookUpKeysFromBackend(com.tandbergtv.cms.services.resources.DistributionSite siteTo, List<String> fileLookupKeys) {
        LookupKeysType lookUpKeysType = new LookupKeysType();
        lookUpKeysType.getLookupKeies().addAll(fileLookupKeys);
        siteTo.setLookupKeys(lookUpKeysType);
    }

    private com.tandbergtv.cms.services.resources.LogicalSite convertLogicalSiteFromBackEndSite(LogicalSite site) {
        com.tandbergtv.cms.services.resources.LogicalSite siteTo = new com.tandbergtv.cms.services.resources.LogicalSite();
        return siteTo;
    }

    private Site convertMediapathDistributionFromBackEndSite(com.ericsson.cms.sites.core.entities.Site site) {
        MediapathSite siteTo = new MediapathSite();
        siteTo.setMetadataFormat(((MediapathDistributionSite)site).getMetadataFormat());
        siteTo.setDistributionOption(((MediapathDistributionSite)site).getDistributionOption().toString());
        siteTo.setAssociatedGroup(((MediapathDistributionSite)site).getAssociatedGroupName());
        siteTo.setDistConfParams(this.getDistConfParams(((MediapathDistributionSite)site).getDistConfParams()));
        siteTo.setExportConfiguration(((MediapathDistributionSite)site).getExportPluginName());
        if (((MediapathDistributionSite)site).getAlertDelayPeriod() != null) {
            siteTo.setAllertDelayPeriod(((MediapathDistributionSite)site).getAlertDelayPeriod().toString());
        }
        siteTo.setExportConfParams(this.getExportConfParams(((MediapathDistributionSite)site).getExportConfParams()));
        if (((MediapathDistributionSite)site).getAssociatedResourceId() != null) {
            siteTo.setAssociatedResource(((MediapathDistributionSite)site).getAssociatedResourceId().toString());
        }
        if (((DistributionSite)site).getFileLookupKeys() != null) {
            this.addLookUpKeysFromBackend(siteTo, ((DistributionSite)site).getFileLookupKeys());
        }
        ((com.tandbergtv.cms.services.resources.DistributionSite)siteTo).setDistributionConfiguration(((DistributionSite)site).getDistTemplateName());
        return siteTo;
    }

    private DistributionSite.ExportConfParams getExportConfParams(Map<String, String> exportConfParams) {
        DistributionSite.ExportConfParams params = new DistributionSite.ExportConfParams();
        if (exportConfParams != null) {
            for (Map.Entry<String, String> mapEntry : exportConfParams.entrySet()) {
                DistributionSite.ExportConfParams.Entry e = new DistributionSite.ExportConfParams.Entry();
                e.setKey(mapEntry.getKey());
                e.setValue(mapEntry.getValue());
                params.getEntries().add(e);
            }
        }
        return params;
    }

    private DistributionSite.DistConfParams getDistConfParams(Map<String, String> distConfParams) {
        DistributionSite.DistConfParams params = new DistributionSite.DistConfParams();
        if (distConfParams != null) {
            for (Map.Entry<String, String> mapEntry : distConfParams.entrySet()) {
                DistributionSite.DistConfParams.Entry e = new DistributionSite.DistConfParams.Entry();
                e.setKey(mapEntry.getKey());
                e.setValue(mapEntry.getValue());
                params.getEntries().add(e);
            }
        }
        return params;
    }

    private Long getResourceId(String associatedResource) {
        ResourceManagement rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        List rgs = rm.getAllResourceGroups();
        if (rgs != null) {
            for (ResourceGroup rg : rgs) {
                if (rg.getResources() == null) continue;
                for (Resource resource : rg.getResources()) {
                    if (resource.getName() == null || !resource.getName().equalsIgnoreCase(associatedResource)) continue;
                    return resource.getId();
                }
            }
        }
        return null;
    }

    private String getAssociatedResourceName(Long associatedResourceId, String groupName) {
        ResourceManagement rm;
        List rgs;
        String resourceName = null;
        if (associatedResourceId != null && groupName != null && (rgs = (rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class)).getAllResourceGroups()) != null) {
            block0: for (ResourceGroup rg : rgs) {
                if (!rg.getName().equalsIgnoreCase(groupName) || rg.getResources() == null) continue;
                for (Resource resource : rg.getResources()) {
                    if (resource.getId() != associatedResourceId.longValue() || resource.getName() == null) continue;
                    resourceName = resource.getName();
                    continue block0;
                }
            }
        }
        return resourceName;
    }

    private Map<String, String> convertConfParams(DistributionSite.ExportConfParams exportConfParams) {
        HashMap<String, String> exportParamsMap = new HashMap<String, String>();
        if (exportConfParams != null) {
            List<DistributionSite.ExportConfParams.Entry> entryList = exportConfParams.getEntries();
            for (DistributionSite.ExportConfParams.Entry entry : entryList) {
                exportParamsMap.put(entry.getKey(), entry.getValue());
            }
        }
        return exportParamsMap;
    }

    private Map<String, String> convertDistParams(DistributionSite.DistConfParams distConfParams) {
        HashMap<String, String> distParamsMap = new HashMap<String, String>();
        if (distConfParams != null) {
            List<DistributionSite.DistConfParams.Entry> entryList = distConfParams.getEntries();
            for (DistributionSite.DistConfParams.Entry entry : entryList) {
                distParamsMap.put(entry.getKey(), entry.getValue());
            }
        }
        return distParamsMap;
    }

    @Override
    @Transactional
    public Response getSite(String authorizationHeader, String contentType, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        String string = authorizationHeader;
        String string2 = contentType;
        String string3 = siteId;
        Date date = lastModified;
        Request request2 = request;
        UriInfo uriInfo2 = uriInfo;
        SecurityContext securityContext = sec;
        return (Response)SiteService.getSite_aroundBody5$advice(this, string, string2, string3, date, request2, uriInfo2, securityContext, TransactionEnforcer.aspectOf(), SiteService.class.getDeclaredMethod("getSite", String.class, String.class, String.class, Date.class, Request.class, UriInfo.class, SecurityContext.class).getAnnotation(Transactional.class), null);
    }

    private void setHref(Site siteTo, UriInfo request) {
        String href = request.getBaseUri() + request.getPath().substring(0);
        siteTo.setHref(href);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response getList_aroundBody0(SiteService this_, String authorizationHeader, Date expires, String contentType, Request request, UriInfo uriInfo, SecurityContext sec) {
        Response.ResponseBuilder builder = null;
        ResourceList list = new ResourceList();
        RESTAuthentication auth = null;
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_VIEW);
            List siteList = this_.siteManager.getAllSites();
            for (com.ericsson.cms.sites.core.entities.Site site : siteList) {
                list.getSites().add(this_.convertResponseSite(site, uriInfo));
            }
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
            builder = Response.ok((Object)list).type(contentType);
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getList_aroundBody1$advice(SiteService this_, String authorizationHeader, Date expires, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getList_aroundBody0(this_, authorizationHeader, expires, contentType, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.getList_aroundBody0(this_, authorizationHeader, expires, contentType, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response createSite_aroundBody2(SiteService this_, String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, Site metadata) {
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        com.ericsson.cms.sites.core.entities.Site site = null;
        RESTAuthentication auth = null;
        if (contentType == null) {
            errors.getErrors().add("Content type not specified");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            try {
                auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_CREATE, PERMISSION_SITES_UPDATE);
                try {
                    site = this_.convertSite(metadata);
                    this_.siteManager.save(site);
                    this_.setPartner(site, metadata);
                }
                catch (Exception e) {
                    errors.getErrors().add(e.getLocalizedMessage());
                    builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            finally {
                if (auth != null) {
                    auth.logout();
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            } else {
                builder = Response.ok((Object)this_.convertResponseSite(site, uriInfo)).type(contentType);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object createSite_aroundBody3$advice(SiteService this_, String authorizationHeader, String contentType, Request request, UriInfo uriInfo, SecurityContext sec, Site metadata, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.createSite_aroundBody2(this_, authorizationHeader, contentType, request, uriInfo, sec, metadata);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.createSite_aroundBody2(this_, authorizationHeader, contentType, request, uriInfo, sec, metadata);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final /* synthetic */ Response getSite_aroundBody4(SiteService this_, String authorizationHeader, String contentType, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec) {
        com.ericsson.cms.sites.core.entities.Site site = null;
        Site siteTo = null;
        ObjectMapper mapper = new ObjectMapper();
        Response.ResponseBuilder builder = null;
        Errors errors = new Errors();
        String jsonResponse = "";
        RESTAuthentication auth = null;
        if (contentType == null) {
            errors.getErrors().add("Content type not specified");
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        } else {
            block13: {
                try {
                    auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_SITES_VIEW);
                    try {
                        site = this_.siteManager.getSite(Integer.valueOf(siteId).intValue());
                        if (site != null) {
                            siteTo = this_.convertFromBackendSite(site, uriInfo);
                            this_.setHref(siteTo, uriInfo);
                            if (contentType.equalsIgnoreCase("application/json")) {
                                mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                                jsonResponse = mapper.writeValueAsString((Object)siteTo);
                                builder = Response.ok((Object)jsonResponse).type(contentType);
                            } else {
                                builder = Response.ok((Object)siteTo).type(contentType);
                            }
                            break block13;
                        }
                        errors.getErrors().add("MSO not found");
                        builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
                    }
                    catch (NumberFormatException e) {
                        errors.getErrors().add("Invalid siteId");
                        builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
                    }
                    catch (Exception e) {
                        errors.getErrors().add(e.getLocalizedMessage());
                        builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
                    }
                }
                finally {
                    if (auth != null) {
                        auth.logout();
                    }
                }
            }
            if (errors.getErrors().size() > 0) {
                builder.entity((Object)errors);
            }
        }
        return builder.build();
    }

    private static final /* synthetic */ Object getSite_aroundBody5$advice(SiteService this_, String authorizationHeader, String contentType, String siteId, Date lastModified, Request request, UriInfo uriInfo, SecurityContext sec, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return SiteService.getSite_aroundBody4(this_, authorizationHeader, contentType, siteId, lastModified, request, uriInfo, sec);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Response object = SiteService.getSite_aroundBody4(this_, authorizationHeader, contentType, siteId, lastModified, request, uriInfo, sec);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

