/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles;

import com.tandbergtv.cms.services.RESTAuthentication;
import com.tandbergtv.cms.services.titles.ITitlesService;
import com.tandbergtv.cms.services.titles.wpcl.AbstractTitlesServiceMessageBuilder;
import com.tandbergtv.cms.services.titles.wpcl.IngestTitleMessageBuilder;
import com.tandbergtv.cms.services.titles.wpcl.PostIngestMessageBuilder;
import com.tandbergtv.neptune.configuration.service.IConfigurationServiceRemote;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;

public class TitlesService
implements ITitlesService {
    private static final String ASYNC_KEY_PARAMETER = "asyncKey";
    private static final String METADATA_DIR_PROPERTY = "metadata.dir";
    private static final String USE_CLASSIC_INGEST_MODE_PROPERTY = "use.classic.ingest.mode";
    private static final int MAX_LENGTH = 1024;
    private static final String PERMISSION_TITLE_CREATE = "AssetManagement_Create";
    private static final String PERMISSION_TITLE_UPDATE = "AssetManagement_Update";
    private ITitleIngester titleIngester = null;
    private static final String NEPTUNE_CONF_REMOTE_NAME = "cms/ConfigurationService/remote";
    private static final String NEPTUNE_ADDRESS = "watchpoint-app:1099";
    private static final String SETTINGS_GROUP = "com.ericsson.cms.contentmgmt.ingest.webservice";
    private static final Logger logger = Logger.getLogger((String)TitlesService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response ingestMetadata(String authorizationHeader, String providerId, String contentClass, UriInfo uriInfo, InputStream metadataInputStream) {
        RESTAuthentication auth = null;
        try {
            auth = RESTAuthentication.loginIfHasAnyOfThePermissions(authorizationHeader, PERMISSION_TITLE_CREATE, PERMISSION_TITLE_UPDATE);
            Map<String, String> additionalParameters = this.extractQueryArgs(uriInfo);
            Response response = this.ingestMetadata(providerId, metadataInputStream, contentClass, additionalParameters, auth);
            return response;
        }
        finally {
            if (auth != null) {
                auth.logout();
            }
        }
    }

    @Override
    public Response ingestMetadata(String authorizationHeader, String providerId, UriInfo uriInfo, InputStream metadataInputStream) {
        return this.ingestMetadata(authorizationHeader, providerId, null, uriInfo, metadataInputStream);
    }

    private Map<String, String> extractQueryArgs(UriInfo uriInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : uriInfo.getQueryParameters().keySet()) {
            result.put(name, (String)uriInfo.getQueryParameters().getFirst((Object)name));
        }
        return result;
    }

    private Response ingestMetadata(String providerId, InputStream metadataInputStream, String contentClass, Map<String, String> additionalParameters, RESTAuthentication auth) {
        PostIngestMessageBuilder postIngestMessageBuilder;
        String metadataFilePath = this.saveMetadataFile(providerId, metadataInputStream);
        String asyncKey = this.generateAsyncKey();
        if (this.useClassicMode()) {
            IngestTitleMessageBuilder ingestMessageBuilder = new IngestTitleMessageBuilder(providerId, contentClass, metadataFilePath, additionalParameters, asyncKey);
            this.sendMessage(ingestMessageBuilder);
            return this.newMetadataIngestionResponse(asyncKey);
        }
        try {
            ISavedTitle savedTitle = this.titleIngester().ingestMetadata(metadataFilePath, providerId, contentClass, this.newTitleActionSource(auth));
            List validationMessages = this.titleIngester().validate(savedTitle.getTitle());
            Long titleId = this.getTitleId(savedTitle);
            String titleStatus = this.getTitleStatus(savedTitle);
            boolean validationSuccess = !this.validationFailed(validationMessages);
            String validationMessage = this.joinValidationMessages(validationMessages);
            postIngestMessageBuilder = new PostIngestMessageBuilder(titleId, titleStatus, providerId, contentClass, metadataFilePath, additionalParameters, asyncKey, validationSuccess, validationMessage);
        }
        catch (TitleValidationException e) {
            postIngestMessageBuilder = new PostIngestMessageBuilder(null, null, providerId, contentClass, metadataFilePath, additionalParameters, asyncKey, false, this.joinValidationMessages(e.getMessages()));
        }
        catch (Exception e) {
            logger.error((Object)("Error saving title" + e.getLocalizedMessage()), (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        this.sendMessage(postIngestMessageBuilder);
        return this.newMetadataIngestionResponse(postIngestMessageBuilder);
    }

    private boolean validationFailed(List<TitleValidationMessage> validationMessages) {
        if (validationMessages != null) {
            for (int i = 0; i < validationMessages.size(); ++i) {
                TitleValidationMessage m = validationMessages.get(i);
                if (!m.getType().equals((Object)TitleValidationMessage.Type.Error)) continue;
                return true;
            }
        }
        return false;
    }

    private Long getTitleId(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null) {
            return null;
        }
        return savedTitle.getTitle().getId();
    }

    private String getTitleStatus(ISavedTitle savedTitle) {
        if (savedTitle == null || savedTitle.getTitle() == null || savedTitle.getTitle().getStatus() == null) {
            return null;
        }
        return savedTitle.getTitle().getStatus().toString();
    }

    private Response newMetadataIngestionResponse(PostIngestMessageBuilder postIngestMessageBuilder) {
        MetadataIngestResponseBuilder builder = new MetadataIngestResponseBuilder();
        Map<String, String> msgParams = postIngestMessageBuilder.getParameters();
        for (String name : msgParams.keySet()) {
            builder.addParameter(name, msgParams.get(name));
        }
        return builder.ok(202);
    }

    private String joinValidationMessages(List<TitleValidationMessage> validationMessages) {
        ArrayList<String> strMessages = new ArrayList<String>();
        for (TitleValidationMessage m : validationMessages) {
            strMessages.add(m.getMessage());
        }
        String message = TitlesService.join(strMessages, "\n");
        if (message != null && message.length() > 1021) {
            return message.substring(0, 1021) + "...";
        }
        return message;
    }

    public static String join(Collection<?> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    private ITitleActionSource newTitleActionSource(RESTAuthentication auth) {
        return new TitleActionSource("Content Management", "Metadata Ingest Service", auth.getUsername());
    }

    private Response newMetadataIngestionResponse(String asyncKey) {
        MetadataIngestResponseBuilder builder = new MetadataIngestResponseBuilder();
        builder.addParameter(ASYNC_KEY_PARAMETER, asyncKey);
        return builder.ok(202);
    }

    private void sendMessage(AbstractTitlesServiceMessageBuilder messageBuilder) {
        try {
            IMessage msg = messageBuilder.build();
            logger.info((Object)("Sending mensage:" + msg.getPayload().getContent()));
            IMessage response = RoutingServiceFactory.newInstance().createRoutingService().send(msg);
            logger.debug((Object)("Response received:" + response.getPayload().getContent()));
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to send an ingest metadata wpcl message", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private Response newErrorResponse(Exception e) {
        return new MetadataIngestResponseBuilder().error(e);
    }

    private String saveMetadataFile(String providerId, InputStream metadataInputStream) {
        String filePath = this.newFilePathForMetadata(providerId);
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int c;
            in = new BufferedInputStream(metadataInputStream);
            out = new BufferedOutputStream(new FileOutputStream(filePath));
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            this.close(in);
            this.close(out);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
                throw new WebApplicationException(this.newErrorResponse(e));
            }
            catch (Throwable throwable) {
                this.close(in);
                this.close(out);
                throw throwable;
            }
        }
        return filePath;
    }

    private void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private void close(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error trying to ingest metadata", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private String newFilePathForMetadata(String providerId) {
        try {
            Map settings = this.getSettingsService().getProperties(SETTINGS_GROUP);
            String baseMetadataDir = (String)settings.get(METADATA_DIR_PROPERTY);
            String dirPath = baseMetadataDir + "/" + providerId + "/";
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String filePath = dirPath + "metadata_" + Calendar.getInstance().getTimeInMillis() + ".xml";
            new File(filePath).createNewFile();
            return filePath;
        }
        catch (IOException e) {
            logger.error((Object)"Error creating file for metadata xml", (Throwable)e);
            throw new WebApplicationException(this.newErrorResponse(e));
        }
    }

    private boolean useClassicMode() {
        IConfigurationServiceRemote neptuneService = this.getSettingsService();
        Map settings = neptuneService.getProperties(SETTINGS_GROUP);
        String mode = (String)settings.get(USE_CLASSIC_INGEST_MODE_PROPERTY);
        if (mode == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(mode.toLowerCase());
    }

    private String generateAsyncKey() {
        return UUID.randomUUID().toString();
    }

    private ITitleIngester titleIngester() {
        if (this.titleIngester == null) {
            this.titleIngester = (ITitleIngester)ServiceRegistry.getDefault().lookup(ITitleIngester.class);
        }
        return this.titleIngester;
    }

    public IConfigurationServiceRemote getSettingsService() {
        Properties properties = new Properties();
        try {
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            properties.put("java.naming.provider.url", NEPTUNE_ADDRESS);
            InitialContext context = new InitialContext(properties);
            Object proxy = context.lookup(NEPTUNE_CONF_REMOTE_NAME);
            return (IConfigurationServiceRemote)proxy;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to lookup settings service", (Throwable)ex);
            return null;
        }
    }

    private class MetadataIngestResponseBuilder {
        private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private List<Parameter> parameters = new ArrayList<Parameter>();
        private static final int HTTP_RESPONSE_ACEPTED = 202;

        public void addParameter(String name, String value) {
            this.parameters.add(new Parameter(name, value));
        }

        public Response ok(int status) {
            return Response.ok((Object)this.buildResponseBody()).status(202).build();
        }

        public Response error(Exception e) {
            return Response.serverError().entity((Object)e.getCause()).build();
        }

        private String buildResponseBody() {
            StringBuilder sb = new StringBuilder();
            sb.append(XML_HEADER);
            for (Parameter p : this.parameters) {
                sb.append("\n");
                sb.append("<");
                sb.append(p.name);
                sb.append(">");
                sb.append(p.value);
                sb.append("</");
                sb.append(p.name);
                sb.append(">");
            }
            return sb.toString();
        }

        private class Parameter {
            String name;
            String value;

            public Parameter(String name, String value) {
                this.name = name;
                this.value = value == null ? "" : value;
            }
        }
    }
}

