/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.titles.wpcl;

import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTitlesServiceMessageBuilder {
    private static final int MAX_PARAMETER_SIZE = 4000;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> additionalParameters;
    private String msgUID;

    public AbstractTitlesServiceMessageBuilder(String msgUID) {
        this.msgUID = msgUID;
    }

    public IMessage build() throws Exception {
        WorkflowMessage msg = this.newNotificationCreateMessage();
        Map<String, String> allParameters = this.getParameters();
        for (String name : allParameters.keySet()) {
            msg.putValue(name, allParameters.get(name));
        }
        return new WPCLConverter().convert(msg);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> allParameters = new HashMap<String, String>();
        if (this.additionalParameters != null) {
            for (String additionalParameterName : this.additionalParameters.keySet()) {
                allParameters.put(additionalParameterName, this.normalizeParameter(this.additionalParameters.get(additionalParameterName)));
            }
        }
        if (this.parameters != null) {
            for (String parameterName : this.parameters.keySet()) {
                allParameters.put(parameterName, this.normalizeParameter(this.parameters.get(parameterName)));
            }
        }
        return allParameters;
    }

    private WorkflowMessage newNotificationCreateMessage() {
        WorkflowMessage msg = WorkflowMessageFactory.createControlMessage((String)this.msgUID);
        msg.setType(WorkflowMessage.MessageType.notification);
        msg.setCommand(new WPCLCommand("create"));
        return msg;
    }

    public void putParameter(String name, Object value) {
        if (value == null) {
            this.parameters.put(name, null);
        } else {
            this.parameters.put(name, value.toString());
        }
    }

    private String normalizeParameter(String value) {
        if (value != null && value.length() > 4000) {
            return value.substring(0, 4000);
        }
        return value;
    }

    public void setAdditionalParameters(Map<String, String> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }
}

