/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.service;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.entities.ContentClassPartnerList;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.workflow.core.service.Service;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface IContentClassService
extends Service {
    public static final String SERVICE_NAME = "ContentClassService";

    public List<ContentClass> getAllContentClassesWithoutMetadata() throws ContentClassPersistenceException;

    public List<ContentClassPartner> getAllContentClassPartnersWithoutMetadata() throws ContentClassPersistenceException;

    public List<ContentClass> getPartnerContentClassesWithoutMetadata(long var1) throws ContentClassPersistenceException;

    public ContentClass getContentClassById(long var1) throws ContentClassPersistenceException;

    public Long getContentClassIdByName(String var1) throws ContentClassPersistenceException;

    public Long getDefaultContentClassId() throws ContentClassPersistenceException;

    public Long getSeriesContentClassId() throws ContentClassPersistenceException;

    public Long getCategoryContentClassId() throws ContentClassPersistenceException;

    public boolean contentClassNameExists(String var1) throws ContentClassPersistenceException;

    public void saveContentClass(ContentClass var1) throws ContentClassPersistenceException;

    public void deleteContentClassById(long var1) throws ContentClassPersistenceException;

    public void deleteContentClassesById(Collection<Long> var1) throws ContentClassPersistenceException;

    public ContentClassPartner getContentClassPartner(long var1, long var3, boolean var5) throws ContentClassPersistenceException;

    public ContentClassPartner getContentClassPartnerMetadata(long var1, long var3) throws ContentClassPersistenceException;

    public List<ContentClassPartner> getContentClassPartnersByContentClassId(long var1, boolean var3) throws ContentClassPersistenceException;

    public ContentClassPartner getMergedContentClassPartnerMetadataForIngest(long var1, long var3) throws ContentClassPersistenceException;

    public ContentClassPartner getMergedContentClassPartnerMetadataForView(long var1, long var3) throws ContentClassPersistenceException;

    public void saveContentClassPartner(ContentClassPartner var1) throws ContentClassPersistenceException;

    public void deleteContentClassPartner(ContentClassPartner var1) throws ContentClassPersistenceException;

    public Map<Long, ContentClassPartnerList> getContentClassPartnerMap(String var1) throws ContentClassPersistenceException;

    public Map<Long, ContentClassPartnerList> getCategoryContentClassPartnerMap(String var1) throws ContentClassPersistenceException;

    public void applyContentClassMetadataForIngest(Title var1) throws ContentClassPersistenceException;

    public void applyContentClassMetadataForView(Title var1) throws ContentClassPersistenceException;

    public boolean contentClassAssociatedWithTitle(long var1) throws ContentClassPersistenceException;

    public boolean contentClassPartnerExists(long var1, long var3) throws ContentClassPersistenceException;

    public String marshalContentClass(ContentClass var1) throws ContentClassPersistenceException;

    public ContentClass unmarshalContentClass(String var1) throws ContentClassPersistenceException;

    public String marshalContentClassWithPartners(ContentClass var1, List<ContentClassPartner> var2) throws ContentClassPersistenceException;

    public ContentClass unmarshalContentClassWithPartners(String var1, List<ContentClassPartner> var2) throws ContentClassPersistenceException;

    public Long getPartnerIdByName(String var1) throws ContentClassPersistenceException;

    public Map<String, Map<String, String>> getFieldsWithOptions() throws ContentClassPersistenceException;

    public Date getContentClassLastUpdateDate() throws ContentClassPersistenceException;

    public boolean isCategoryPackage(long var1) throws ContentClassPersistenceException;
}

