/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.entities;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public class Title
implements Serializable {
    private static final long serialVersionUID = -5335618502714977317L;
    private Long id;
    private Long contentClassId;
    private Long partnerId;
    private TitleStatus status;
    private String externalLocation;
    private String metadataContent;
    private Asset asset = null;
    private Long documentId = 0L;
    private Collection<IAssetList> titlelists;
    private Collection<ProgressItem> progressItems;
    private Map<String, TitleStatus> assetVersionStatusMap;
    private Long originalId;
    private String originalVersion;
    private Date lastModifiedTime;
    private Date retirementDate;
    private static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";

    public Title() {
        this.progressItems = new ArrayList<ProgressItem>();
        this.titlelists = new ArrayList<IAssetList>();
        this.status = TitleStatus.DRAFT;
        this.assetVersionStatusMap = new HashMap<String, TitleStatus>();
        this.documentId = 0L;
    }

    public Title(Title title) {
        this.id = title.id;
        this.contentClassId = title.contentClassId;
        this.partnerId = title.partnerId;
        this.status = title.status;
        this.externalLocation = title.externalLocation;
        this.metadataContent = title.metadataContent;
        this.asset = title.asset;
        this.documentId = title.documentId;
        this.titlelists = title.titlelists;
        this.progressItems = title.progressItems;
        this.assetVersionStatusMap = title.assetVersionStatusMap;
        this.originalId = title.originalId;
        this.originalVersion = title.originalVersion;
        this.lastModifiedTime = title.lastModifiedTime;
        this.retirementDate = title.retirementDate;
    }

    public Title(Long id) {
        this();
        this.id = id;
    }

    public Title(TitleStatus status) {
        this();
        this.status = status;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDocumentId() {
        return this.asset != null ? this.asset.getId() : this.documentId.longValue();
    }

    public void setDocumentId(Long documentId) {
        if (this.asset != null) {
            throw new IllegalStateException("Cannot set the title document ID when the root asset is set for the title.");
        }
        this.documentId = documentId;
    }

    public Long getContentClassId() {
        return this.contentClassId;
    }

    public void setContentClassId(Long contentClassId) {
        this.contentClassId = contentClassId;
    }

    public Long getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(Long partnerId) {
        this.partnerId = partnerId;
    }

    public TitleStatus getStatus() {
        return this.status;
    }

    public void setStatus(TitleStatus status) {
        this.status = status;
    }

    public String getExternalLocation() {
        return this.externalLocation;
    }

    public void setExternalLocation(String externalLocation) {
        this.externalLocation = externalLocation;
    }

    public String getMetadataContent() {
        return this.metadataContent;
    }

    public void setMetadataContent(String metadataContent) {
        this.metadataContent = metadataContent;
    }

    @Transactional
    public Asset getAsset() {
        if (this.asset == null && this.documentId != null && this.documentId != 0L) {
            ITitleManager titleManager = ServiceRegistry.getDefault().lookup(ITitleManager.class);
            this.asset = titleManager.getAsset(this.documentId);
        }
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
        this.documentId = this.asset != null ? Long.valueOf(asset.getId()) : null;
    }

    public String getVersion() {
        return this.getAsset() != null ? this.getAsset().getVersion() : null;
    }

    public Boolean getIsActive() {
        return this.getAsset().isActive();
    }

    public void setIsActive(Boolean isActive) {
        this.getAsset().setState(isActive);
    }

    public Collection<IAssetList> getTitlelists() {
        return this.titlelists;
    }

    public Collection<ProgressItem> getProgressItems() {
        ArrayList<ProgressItem> progressItems = new ArrayList<ProgressItem>();
        for (ProgressItem progress : this.progressItems) {
            if (!progress.getIsActive().booleanValue()) continue;
            progressItems.add(progress);
        }
        return progressItems;
    }

    public Collection<ProgressItem> getAllProgressItems() {
        return new ArrayList<ProgressItem>(this.progressItems);
    }

    public Map<String, TitleStatus> getAssetStatusMap() {
        return this.assetVersionStatusMap;
    }

    public void setAssetStatusMap(Map<String, TitleStatus> assetStatusMap) {
        this.assetVersionStatusMap = assetStatusMap;
    }

    public TitleStatus getStatus(String version) {
        return this.assetVersionStatusMap.get(version);
    }

    public Long getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public void setOriginalVersion(String originalVersion) {
        this.originalVersion = originalVersion;
    }

    public boolean isCopy() {
        return this.getOriginalId() != null;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getRetirementDate() {
        return this.retirementDate;
    }

    public void setRetirementDate(Date retirementDate) {
        this.retirementDate = retirementDate;
    }

    public boolean hasBeenRetired() {
        return this.retirementDate != null;
    }

    public String toString() {
        String desc = "[" + this.id + " | " + this.getAsset().getId() + "] ";
        if (this.isCopy()) {
            desc = desc + "copied from [" + this.getOriginalId() + " v" + this.getOriginalVersion() + "] ";
        }
        desc = desc + this.status;
        return desc;
    }

    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return 31 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Title)) {
            return false;
        }
        Title other = (Title)obj;
        return this.id != null && this.id.equals(other.getId());
    }

    public Collection<Asset> getAllAssets(boolean includeFiles) {
        Asset rootAsset = this.getAsset();
        return rootAsset != null ? rootAsset.getAllAssets(includeFiles) : new ArrayList();
    }

    public Asset getAsset(long assetId) {
        for (Asset a : this.getAssetsInBreadthFirstOrder()) {
            if (a.getId() != assetId) continue;
            return a;
        }
        return null;
    }

    public void removeAsset(Asset assetToRemove) {
        Asset rootAsset = this.getAsset();
        if (assetToRemove.equals(rootAsset)) {
            throw new IllegalArgumentException("Cannot remove the root asset from the title.");
        }
        if (rootAsset != null) {
            rootAsset.removeAsset(assetToRemove);
        }
    }

    public List<Asset> getAssets(String assetType) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        if (assetType == null) {
            throw new IllegalArgumentException("assetType can't be null");
        }
        for (Asset asset : this.getAssetsInBreadthFirstOrder()) {
            if (asset == null || !assetType.equals(asset.getAssetType())) continue;
            result.add(asset);
        }
        return result;
    }

    public Asset getAssetContainingFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        return this.findFirstNotFileAscendant(file);
    }

    private Asset findFirstNotFileAscendant(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        LinkedList<Asset> assetStack = new LinkedList<Asset>();
        assetStack.add(this.getAsset());
        LinkedList<Asset> firstNotFileAscendantStack = new LinkedList<Asset>();
        firstNotFileAscendantStack.add(null);
        while (assetStack.size() > 0) {
            Asset asset = (Asset)assetStack.removeLast();
            Asset firstNotFileAscendant = (Asset)firstNotFileAscendantStack.removeLast();
            if (asset == file || file.getId() > 0L && file.getId() == asset.getId()) {
                return firstNotFileAscendant;
            }
            Asset firstNotFileAscendantOfChildren = null;
            firstNotFileAscendantOfChildren = !this.assetIsAFile(asset) ? asset : firstNotFileAscendant;
            for (Asset child : asset.getImmediateChildren()) {
                if (assetStack.contains(child)) continue;
                assetStack.add(child);
                firstNotFileAscendantStack.add(firstNotFileAscendantOfChildren);
            }
        }
        throw new IllegalArgumentException("file not found on asset tree");
    }

    private boolean assetIsAFile(Asset asset) {
        return asset instanceof File;
    }

    public void addFile(Asset parentAsset, File file) {
        if (parentAsset == null) {
            throw new IllegalArgumentException("parentAsset can't be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        List<File> files = this.getFilesInSiblingSubtreesOfFiles(parentAsset);
        this.removeClashingLookupKeys(this.getLookupKey(file), files);
        if (file.isOriginal()) {
            this.changeFileTypeToHistoricalIfOriginal(files);
        }
        parentAsset.addChild(file);
    }

    private void changeFileTypeToHistoricalIfOriginal(List<File> files) {
        for (File file : files) {
            if (!file.isOriginal()) continue;
            file.setFileType(FileType.HISTORICAL);
        }
    }

    private String getLookupKey(File file) {
        if (file == null) {
            return null;
        }
        Field lookupKeyField = file.getFirstField(FILE_LOOKUP_KEY_XPATH);
        if (lookupKeyField == null) {
            return null;
        }
        return lookupKeyField.getValue();
    }

    private void setLookupKey(File file, String lookupKey) {
        Field field = file.getFirstField(FILE_LOOKUP_KEY_XPATH);
        if (field == null) {
            file.addField(new Field(FILE_LOOKUP_KEY_XPATH, lookupKey));
        } else {
            field.setValue(lookupKey);
        }
    }

    private void removeClashingLookupKeys(String lookupKey, List<File> files) {
        if (lookupKey == null) {
            return;
        }
        for (File file : files) {
            if (!lookupKey.equals(this.getLookupKey(file))) continue;
            this.setLookupKey(file, "");
        }
    }

    private List<File> getFilesInSiblingSubtreesOfFiles(Asset asset) {
        Asset parentOfSubtrees = null;
        parentOfSubtrees = this.assetIsAFile(asset) ? this.getAssetContainingFile((File)asset) : asset;
        return parentOfSubtrees.getDirectDescendantFiles();
    }

    private List<Asset> getAssetsInBreadthFirstOrder(Asset asset) {
        ArrayList<Asset> result = new ArrayList<Asset>();
        result.add(asset);
        int currentIndex = 0;
        while (currentIndex < result.size()) {
            Asset currentAsset = (Asset)result.get(currentIndex++);
            for (Asset childAsset : currentAsset.getImmediateChildren()) {
                if (result.contains(childAsset)) continue;
                result.add(childAsset);
            }
        }
        return result;
    }

    public List<File> getAllFiles() {
        ArrayList<File> result = new ArrayList<File>();
        for (Asset a : this.getAssetsInBreadthFirstOrder()) {
            if (!this.assetIsAFile(a)) continue;
            result.add((File)a);
        }
        return result;
    }

    public File getFile(Long fileAssetId) {
        if (fileAssetId == null) {
            return null;
        }
        for (File f : this.getAllFiles()) {
            if (f == null || !fileAssetId.equals(f.getId())) continue;
            return f;
        }
        return null;
    }

    public void updateFileLookupKey(File file, String lookupKey) {
        if (file == null) {
            throw new IllegalArgumentException("File can't be null");
        }
        List<File> files = this.getFilesInSiblingSubtreesOfFiles(file);
        this.removeClashingLookupKeys(lookupKey, files);
        this.setLookupKey(file, lookupKey);
    }

    private List<Asset> getAssetsInBreadthFirstOrder() {
        Asset rootAsset = this.getAsset();
        return rootAsset != null ? this.getAssetsInBreadthFirstOrder(rootAsset) : new ArrayList();
    }

    public Title clone() {
        Title t = new Title(this);
        t.asset = this.asset.fieldsClone();
        return t;
    }
}

