/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.ChangeListener;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.FieldTree;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IAssetVisitor;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.ParentChildRelation;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.TrackableArrayList;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.metadatamanager.util.FieldAliasMappingReader;
import com.tandbergtv.metadatamanager.util.FileFieldMappingReader;
import com.tandbergtv.metadatamanager.util.XPathTranslator;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public abstract class Asset
implements Serializable {
    private static final long serialVersionUID = -2345410735316891389L;
    private static final Logger logger = Logger.getLogger(Asset.class);
    private static final String _CUSTOMFIELD = "CustomField";
    private static final String _XPATH_SPLIT = "/";
    private static final String _ATTRIBUTE = "@";
    private static final String _TNS = "";
    private static final String _TNS_FIELDS = "Fields";
    private long id;
    private String displayId;
    private String path;
    private TrackableArrayList fields;
    private List<FieldRevision> fieldRevisions;
    private List<Field> allDescendantAssetFields;
    private List<Asset> allDescendantAssets;
    private Asset root = null;
    private Long originalAssetID;
    private Integer originalRevisionNumber;
    private transient boolean originalRevisionChanged = false;
    private FieldTree fieldTree;
    private int latestRevisionNumber = 1;
    private boolean isRevisionNumberUpdated = false;
    private transient boolean specKeyValuesHasChanged = true;
    private Set<ISpecHandler> specHandlersForValidation;
    private Map<String, FieldRevision> fieldRevisionsMap;
    private Map<String, Field> fieldsMap;
    private Map<String, Field> fieldsMapByPathValue;
    private List<Relation> relations;
    private AssetState state;
    private String externalRevision;
    public static String EXTERNAL_INTERNAL_REVISION_DELIMITER = ".";
    public static String REVISION_FORMAT = "ExternalRevision" + EXTERNAL_INTERNAL_REVISION_DELIMITER + "InternalRevision";
    private ArrayList<ChangeListener> listeners = new ArrayList();

    public Asset() {
        this.fields = new TrackableArrayList();
        this.relations = new ArrayList<Relation>();
        this.state = AssetState.ACTIVE;
    }

    public abstract String getType();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getOriginalAssetID() {
        return this.originalAssetID;
    }

    public void setOriginalAssetID(Long originalAssetID) {
        this.originalAssetID = originalAssetID;
    }

    public Integer getOriginalRevisionNumber() {
        return this.originalRevisionNumber;
    }

    public void setOriginalRevisionNumber(Integer originalRevisionNumber) {
        if (!this.isMatchingOriginalRevision(originalRevisionNumber)) {
            this.setOriginalRevisionChanged(true);
        }
        this.originalRevisionNumber = originalRevisionNumber;
    }

    public boolean isOriginalRevisionChanged() {
        return this.originalRevisionChanged;
    }

    public void setOriginalRevisionChanged(boolean originalRevisionChanged) {
        this.originalRevisionChanged = originalRevisionChanged;
    }

    private boolean isMatchingOriginalRevision(Integer value) {
        Integer original = this.originalRevisionNumber;
        return original == value || original != null && original.equals(value);
    }

    public boolean isCopy() {
        return this.originalAssetID != null;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields.clear();
        for (Field f : fields) {
            this.addField(f);
        }
    }

    public void addField(Field field) {
        Asset root;
        XPathTranslator x = new XPathTranslator();
        if (x.getType(field.getTtvXPath()) == XPathTranslator.XPathType.TTV_XPATH) {
            x.translateTTVtoECMF(field);
        }
        if ((root = this.getRoot()) == null) {
            root = this;
        }
        field.setParentAsset(this);
        field.setRoot(root);
        this.fields.add(field);
        this.logValue(field);
    }

    private void logValue(Field field) {
        if (field.root.getRegisteredListeners().isEmpty()) {
            return;
        }
        String newValue = field.getValue();
        String originalValue = _TNS;
        if (newValue == null) {
            newValue = _TNS;
        }
        if (!originalValue.equals(newValue)) {
            for (ChangeListener listener : field.root.getRegisteredListeners()) {
                listener.handleChange(field.getTtvXPath(), field.getParentAsset().getPath(), originalValue, newValue);
            }
        }
    }

    public void addFieldRevision(FieldRevision fieldRevision, NextRevision nextRevision) {
        this.setLatestRevisionNumber(nextRevision.getRevisionNumber());
    }

    public void addChild(Asset child) {
        logger.debug((Object)("added a new child to asset(" + this.getId() + ")"));
        this.addRelation(new ParentChildRelation(this, child));
    }

    public void addChild(Asset child, NextRevision nextRevision, boolean isChildNew) {
        this.addRelation(new ParentChildRelation(this, child, nextRevision));
        this.setLatestRevisionNumber(nextRevision.getRevisionNumber());
        if (isChildNew) {
            AssetUtil.copyFieldsToFieldRevisions(child, nextRevision);
        }
    }

    public void addRelation(Relation relation) {
        if (relation.getOwnerAsset() != this) {
            String msg = "Cannot add a relation to an asset where the asset is not the owner.";
            throw new IllegalArgumentException(msg);
        }
        this.relations.add(relation);
        Asset child = relation.getTargetAsset();
        if (relation instanceof ParentChildRelation) {
            child.root = this.root == null ? this : this.root;
            child.reRootFields();
        }
    }

    private void reRootFields() {
        for (Field field : this.fields) {
            field.setRoot(this.root);
        }
        for (Relation relation : this.relations) {
            if (!(relation instanceof ParentChildRelation) || !relation.getOwnerAsset().equals(this)) continue;
            Asset asset = relation.getTargetAsset();
            asset.root = this.root;
            asset.reRootFields();
        }
    }

    public AssetState getState() {
        return this.state;
    }

    public boolean isActive() {
        return this.state == AssetState.ACTIVE;
    }

    public void setState(AssetState state) {
        this.state = state;
    }

    public void setState(boolean state) {
        if (state) {
            this.setState(AssetState.ACTIVE);
        } else {
            this.setState(AssetState.INACTIVE);
        }
    }

    public List<Field> getAllDescendantAssetFields() {
        return this.allDescendantAssetFields;
    }

    public void setAllDescendantAssetFields(List<Field> allFields) {
        this.allDescendantAssetFields = allFields;
    }

    public List<Asset> getAllDescendantAssets() {
        return this.allDescendantAssets;
    }

    public void setAllDescendantAssets(List<Asset> allDescendantAssets) {
        this.allDescendantAssets = allDescendantAssets;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    public Asset getRoot() {
        return this.root;
    }

    public TTVId getTTVId() {
        return IdentifierFactory.getTTVIdentifier(this.id);
    }

    public void setTTVId(TTVId id) {
        this.id = id.getId();
    }

    public Asset getAssetsParent(Asset a) {
        for (Relation r : this.relations) {
            Asset targetAsset = r.getTargetAsset();
            if (targetAsset.getId() == a.getId()) {
                return this;
            }
            Asset asset = targetAsset.getAssetsParent(a);
            if (asset == null) continue;
            return asset;
        }
        return null;
    }

    public void removeAsset(Asset assetToRemove) {
        if (assetToRemove.equals(this)) {
            throw new IllegalArgumentException("Cannot remove the root asset from the asset tree.");
        }
        this.removeAsset(this, assetToRemove);
    }

    private void removeAsset(Asset parent, Asset assetToRemove) {
        Iterator<Relation> relationIterator = parent.relations.iterator();
        while (relationIterator.hasNext()) {
            Relation relation = relationIterator.next();
            Asset targetAsset = relation.getTargetAsset();
            if (assetToRemove.equals(targetAsset)) {
                relationIterator.remove();
                continue;
            }
            this.removeAsset(targetAsset, assetToRemove);
        }
    }

    public Field getFirstField(String xpath) {
        String ecmfXpath = this.checkAndGetEcmfXpath(xpath);
        for (Field f : this.fields) {
            if (!f.getTtvXPath().equals(ecmfXpath)) continue;
            return f;
        }
        return null;
    }

    public Field updateFieldValue(String xpath, String value) {
        Field field = this.getOrCreateField(xpath);
        field.setValue(value);
        return field;
    }

    public Field updateTypedFieldValue(String xpath, Object value) {
        Field field = this.getOrCreateField(xpath);
        field.setTypedValue(value);
        return field;
    }

    private Field getOrCreateField(String xpath) {
        Field field = this.getFirstField(xpath);
        if (field == null) {
            field = new Field();
            String ecmfXpath = this.checkAndGetEcmfXpath(xpath);
            field.setTtvXPath(ecmfXpath);
            this.updateFieldIndices(field);
            this.addField(field);
        }
        return field;
    }

    protected void updateFieldIndices(Field field) {
        String[] a = field.getTtvXPath().split(_XPATH_SPLIT);
        if (a.length == 0) {
            throw new IllegalArgumentException("Field (" + field + ") has invalid name");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String s : a) {
            if (s.equals(_TNS) || s.startsWith(_ATTRIBUTE)) continue;
            indices.add(new Integer(1));
        }
        field.setIndices(indices);
    }

    public List<Field> getAllFieldsForXpath(List<String> assetTypes, String xpath) {
        ArrayList<Field> list = new ArrayList<Field>();
        List<Asset> assets = this.getAllAssetsWithLineage(assetTypes);
        for (Asset child : assets) {
            list.addAll(child.getFields(xpath));
        }
        return list;
    }

    @Deprecated
    public List<Field> getAllFieldsForXpath(String assetType, String xpath) {
        List<Field> list = new ArrayList<Field>();
        List<Asset> assets = this.getAllAssetsOfType(assetType);
        for (Asset child : assets) {
            list = child.getFields(xpath);
        }
        return list;
    }

    public List<Asset> getAllAssetsOfType(String assetType) {
        Item item;
        String type;
        List<Asset> assets = this.getTargetAssets(assetType);
        Asset a = new AssetUtil().unWrap(this);
        if (a instanceof Group) {
            Group group = (Group)a;
            String type2 = group.getType().toString();
            if (type2.toLowerCase().equals(assetType.toLowerCase())) {
                assets.add(a);
            }
        } else if (a instanceof Item && (type = (item = (Item)a).getType().toString()).toLowerCase().equals(assetType.toLowerCase())) {
            assets.add(a);
        }
        return assets;
    }

    public List<Asset> getAllAssetsWithLineage(List<String> assetTypes) {
        if (assetTypes.isEmpty()) {
            return new ArrayList<Asset>();
        }
        ArrayList<Asset> results = new ArrayList<Asset>();
        this.getAllAssetsWithLineageRec(assetTypes, 0, this, results);
        return results;
    }

    private void getAllAssetsWithLineageRec(List<String> assetTypes, int index, Asset currAsset, List<Asset> results) {
        String assetType = assetTypes.get(index);
        String type = currAsset.getType().toString();
        if (type.equalsIgnoreCase(assetType) && assetTypes.size() - 1 == index) {
            results.add(currAsset);
        } else if (type.equalsIgnoreCase(assetType)) {
            for (Relation relation : currAsset.getRelations()) {
                Asset ta = new AssetUtil().unWrap(relation.getTargetAsset());
                this.getAllAssetsWithLineageRec(assetTypes, index + 1, ta, results);
            }
        }
    }

    public List<FieldTree> getFieldTreeForXpath(List<String> assetTypes, String xpath) {
        ArrayList<FieldTree> fieldTreeList = new ArrayList<FieldTree>();
        List<Asset> assets = this.getAllAssetsWithLineage(assetTypes);
        List<Object> fieldList = new ArrayList();
        for (Asset a : assets) {
            fieldList = a.getFields(xpath);
            if (fieldList == null || fieldList.size() <= 0) continue;
            FieldTree tree = new FieldTree(xpath, 1);
            this.populateFieldTree(tree, fieldList);
            fieldTreeList.add(tree);
        }
        return fieldTreeList;
    }

    @Deprecated
    public List<FieldTree> getFieldTreeForXpath(String assetType, String xpath) {
        ArrayList<FieldTree> fieldTreeList = new ArrayList<FieldTree>();
        List<Asset> assets = this.getAllAssetsOfType(assetType);
        List<Object> fieldList = new ArrayList();
        for (Asset a : assets) {
            fieldList = a.getFields(xpath);
            if (fieldList == null || fieldList.size() <= 0) continue;
            FieldTree tree = new FieldTree(xpath, 1);
            this.populateFieldTree(tree, fieldList);
            fieldTreeList.add(tree);
        }
        return fieldTreeList;
    }

    public Asset getAsset(long id) {
        for (Relation relation : this.getRelations()) {
            Asset a = relation.getTargetAsset();
            if (a.getId() != id) continue;
            return a;
        }
        return null;
    }

    public Asset getAsset(SearchCriteria searchCriteria) {
        Asset returnAsset = null;
        for (Relation relation : this.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            if (!targetAsset.meetCriteria(searchCriteria)) continue;
            returnAsset = targetAsset;
            break;
        }
        return returnAsset;
    }

    protected boolean meetCriteria(SearchCriteria searchCriteria) {
        boolean result = true;
        for (Map.Entry criteriaEntry : searchCriteria.entrySet()) {
            if (this.getFieldsMapByPathValue().containsKey((String)criteriaEntry.getKey() + (String)criteriaEntry.getValue())) continue;
            result = false;
            break;
        }
        return result;
    }

    public List<Asset> getTargetAssets(String targetAssetType) {
        ArrayList<Asset> targetAssetList = new ArrayList<Asset>();
        Asset ta = null;
        for (Relation relation : this.getRelations()) {
            Group group;
            String type;
            ta = new AssetUtil().unWrap(relation.getTargetAsset());
            if (ta instanceof Item) {
                Item item = (Item)ta;
                type = item.getType().toString();
                if (!type.toLowerCase().equals(targetAssetType.toLowerCase())) continue;
                targetAssetList.add(ta);
                continue;
            }
            if (!(ta instanceof Group) || !(type = (group = (Group)ta).getType().toString()).toLowerCase().equals(targetAssetType.toLowerCase())) continue;
            targetAssetList.add(ta);
        }
        return targetAssetList;
    }

    public <T extends Asset> List<T> getChildrenOfType(Class<T> clazz) {
        Asset ta = null;
        ArrayList<T> list = new ArrayList<T>();
        for (Relation relation : this.getRelations()) {
            ta = new AssetUtil().unWrap(relation.getTargetAsset());
            if (!clazz.isAssignableFrom(ta.getClass())) continue;
            list.add(clazz.cast(ta));
        }
        return list;
    }

    public List<Asset> getAllDescendantItems(boolean includeFiles) {
        ArrayList<Asset> list = new ArrayList<Asset>();
        this.walkAssetTree(this, list, includeFiles, true);
        return list;
    }

    public List<Asset> getAllAssets(boolean includeFiles) {
        ArrayList<Asset> list = new ArrayList<Asset>();
        this.walkAssetTree(this, list, includeFiles, false);
        return list;
    }

    private void walkAssetTree(Asset asset, List<Asset> list, boolean includeFiles, boolean includeOnlyItems) {
        if ((asset = new AssetUtil().unWrap(asset)) instanceof Item) {
            if (asset instanceof File) {
                if (includeFiles) {
                    list.add(asset);
                }
            } else {
                list.add(asset);
            }
        } else if (!includeOnlyItems && asset != null) {
            list.add(asset);
        }
        for (Relation r : asset.getRelations()) {
            this.walkAssetTree(r.getTargetAsset(), list, includeFiles, includeOnlyItems);
        }
    }

    public List<File> getDirectDescendantFiles() {
        ArrayList<File> list = new ArrayList<File>();
        this.getAllFilesRecursively(this, list, true);
        return list;
    }

    public List<File> getAllDescendantFiles() {
        ArrayList<File> list = new ArrayList<File>();
        this.getAllFilesRecursively(this, list, false);
        return list;
    }

    private void getAllFilesRecursively(Asset asset, List<File> list, boolean onlyFilesInThisAsset) {
        if ((asset = new AssetUtil().unWrap(asset)) instanceof File) {
            list.add((File)asset);
        }
        if (asset.getRelations() != null) {
            for (Relation r : asset.getRelations()) {
                Asset targetAsset = r.getTargetAsset();
                if (onlyFilesInThisAsset && !(targetAsset instanceof File)) continue;
                this.getAllFilesRecursively(targetAsset, list, onlyFilesInThisAsset);
            }
        }
    }

    public String toString() {
        String EOL = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.id).append(" v").append(this.getVersion());
        builder.append(" (" + this.getAssetType() + ")]");
        if (this.isCopy()) {
            builder.append(" copied from [").append(this.originalAssetID);
            builder.append(" v" + this.originalRevisionNumber + "]");
        }
        if (this.relations != null) {
            builder.append(", ").append(this.relations.size()).append(" relation(s)");
        }
        builder.append(EOL);
        builder.append("lineage: " + this.getPath());
        builder.append(EOL);
        for (Field field : this.fields) {
            builder.append("\t").append(field).append(EOL);
        }
        return builder.toString();
    }

    public void accept(IAssetVisitor visitor) {
        visitor.unWrap(this);
    }

    public boolean isInstance(Class<?> clazz) {
        return this.getClass().isAssignableFrom(clazz);
    }

    public FieldTree getFieldTree() {
        this.fieldTree = new FieldTree();
        this.populateFieldTree(this.fieldTree, this.fields);
        return this.fieldTree;
    }

    public void setFieldTree(FieldTree fieldTree) {
        this.fieldTree = fieldTree;
        List<Field> fields = this.buildFieldListFromTree(fieldTree);
        this.setFields(fields);
    }

    private void populateFieldTree(FieldTree fieldTree, List<Field> fields) {
        for (Field f : fields) {
            FieldTreeNode rootNode;
            String xpath = f.getTtvXPath();
            String[] xpathParts = xpath.split(_XPATH_SPLIT);
            FieldTreeNode node = null;
            FieldTreeNode parentNode = null;
            parentNode = rootNode = fieldTree.getRootElement();
            for (int i = 0; i < xpathParts.length; ++i) {
                String xpathPart = xpathParts[i];
                if (xpathPart.equals(_TNS) || xpathPart.equals(_TNS_FIELDS)) continue;
                xpathPart = xpathPart.replace(_TNS, _TNS);
                boolean isAttribute = false;
                if (!xpathPart.contains(_CUSTOMFIELD) && xpathPart.contains(_ATTRIBUTE)) {
                    isAttribute = true;
                    xpathPart = xpathPart.replace(_ATTRIBUTE, _TNS);
                }
                Integer curIndex = 0;
                curIndex = isAttribute ? Integer.valueOf(1) : f.getIndices().get(i - 1);
                node = parentNode.getNode(xpathPart, curIndex);
                if (node == null) {
                    node = new FieldTreeNode();
                    node.setName(xpathPart);
                    node.setCurrentIndex(curIndex);
                    parentNode.addChild(node);
                }
                if (i == xpathParts.length - 1) {
                    node.setField(f);
                    node.setAttribute(isAttribute);
                }
                parentNode = node;
            }
        }
        this.sortTreeNodes(fieldTree.getRootElement(), new FieldTreeNodeComparator());
    }

    private void sortTreeNodes(FieldTreeNode fieldTreeNode, Comparator<FieldTreeNode> comparator) {
        Collections.sort(fieldTreeNode.getChildren(), comparator);
        for (FieldTreeNode child : fieldTreeNode.getChildren()) {
            this.sortTreeNodes(child, comparator);
        }
    }

    private List<Field> buildFieldListFromTree(FieldTree fieldTree) {
        ConcurrentLinkedQueue<FieldTreeNode> queue = new ConcurrentLinkedQueue<FieldTreeNode>();
        fieldTree.breadthFirstTraversal(queue);
        List<Field> fields = fieldTree.depthFirstTraversal();
        return fields;
    }

    public int getLatestRevisionNumber() {
        return this.latestRevisionNumber;
    }

    public void setLatestRevisionNumber(int latestRevisionNumber) {
        if (!this.isRevisionNumberUpdated) {
            this.setRevisionNumberUpdated(true);
        }
        this.latestRevisionNumber = latestRevisionNumber;
    }

    public boolean isRevisionNumberUpdated() {
        return this.isRevisionNumberUpdated;
    }

    public void setRevisionNumberUpdated(boolean isRevisionNumberUpdated) {
        this.isRevisionNumberUpdated = isRevisionNumberUpdated;
    }

    public List<FieldRevision> getFieldRevisions() {
        return this.fieldRevisions;
    }

    public void setFieldRevisions(List<FieldRevision> fieldRevisions) {
        this.fieldRevisions = fieldRevisions;
    }

    public String getAssetType() {
        String assetType = _TNS;
        if (this instanceof Group) {
            Group g = (Group)this;
            assetType = g.getType();
        } else {
            Item i = (Item)this;
            assetType = i.getType();
        }
        return assetType;
    }

    public String getExternalRevision() {
        return this.externalRevision;
    }

    public void setExternalRevision(String externalRevision) {
        this.externalRevision = externalRevision;
    }

    public String getVersion() {
        return Asset.getVersion(this.getExternalRevision(), this.getLatestRevisionNumber());
    }

    public static String getVersion(String externalRevision, int revisionNumber) {
        String version;
        String string = version = externalRevision != null ? externalRevision.trim() : _TNS;
        if (version.length() != 0) {
            version = version + EXTERNAL_INTERNAL_REVISION_DELIMITER;
        }
        version = version + revisionNumber;
        return version;
    }

    public static String getExternalRevision(String version) {
        int delimiterIndex = version.lastIndexOf(EXTERNAL_INTERNAL_REVISION_DELIMITER);
        return delimiterIndex != -1 ? version.substring(0, delimiterIndex) : null;
    }

    public static int getInternalRevision(String version) {
        int delimiterIndex = version.lastIndexOf(EXTERNAL_INTERNAL_REVISION_DELIMITER);
        String revision = delimiterIndex != -1 ? version.substring(delimiterIndex + 1) : version;
        return Integer.parseInt(revision);
    }

    public List<Asset> getImmediateChildren() {
        ArrayList<Asset> immediateChildren = new ArrayList<Asset>();
        for (Relation r : this.relations) {
            immediateChildren.add(r.getTargetAsset());
        }
        return immediateChildren;
    }

    public Map<String, FieldRevision> getFieldRevisionsMap() {
        if (this.fieldRevisionsMap == null) {
            this.fieldRevisionsMap = new HashMap<String, FieldRevision>();
            this.constructIFieldMap(this.getFieldRevisions(), this.fieldRevisionsMap);
        }
        return this.fieldRevisionsMap;
    }

    public void setFieldRevisionsMap(Map<String, FieldRevision> fieldRevisionsMap) {
        this.fieldRevisionsMap = fieldRevisionsMap;
    }

    public Map<String, Field> getFieldsMap() {
        this.initFieldsMap();
        return this.fieldsMap;
    }

    public Map<String, Field> getFieldsMapByPathValue() {
        this.initFieldsMap();
        return this.fieldsMapByPathValue;
    }

    private void initFieldsMap() {
        if (this.fieldsMap == null && this.fieldsMapByPathValue == null) {
            this.fieldsMap = new HashMap<String, Field>();
            this.fieldsMapByPathValue = new HashMap<String, Field>();
            this.constructFieldMap(this.getFields(), this.fieldsMap, this.fieldsMapByPathValue);
        }
    }

    public void setFieldsMap(Map<String, Field> fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    public void updateWithFileMetadata(File file) throws MetadataException {
        FileFieldMappingReader ffmr = FileFieldMappingReader.getInstance();
        Map<String, String> map = ffmr.getAssetFileFieldMap(this.getAssetType().toLowerCase());
        if (map != null) {
            for (String fileFieldXpath : map.keySet()) {
                String assetFieldXpath = map.get(fileFieldXpath);
                Field fileField = file.getFirstField(fileFieldXpath);
                if (fileField == null) continue;
                Field assetField = this.getFirstField(assetFieldXpath);
                if (assetField != null) {
                    assetField.setValue(fileField.getValue());
                    continue;
                }
                Field field = new Field(assetFieldXpath, fileField.getValue());
                ArrayList<Integer> indices = new ArrayList<Integer>();
                String slashes = assetFieldXpath.replaceAll("[^(/|@)]", _TNS);
                slashes = slashes.replaceAll("/@", _TNS);
                for (int i = 0; i < slashes.length(); ++i) {
                    indices.add(1);
                }
                field.setIndices(indices);
                this.addField(field);
            }
        }
    }

    protected <N extends IField> void constructIFieldMap(List<N> iFields, Map<String, N> iFieldsMap) {
        if (iFields == null) {
            return;
        }
        for (IField iField : iFields) {
            iFieldsMap.put(iField.getTtvXPath() + iField.getIndices(), iField);
        }
    }

    protected <N extends IField> void constructFieldMap(List<N> iFields, Map<String, N> iFieldsMap, Map<String, N> iFieldsMapByTTVXpath) {
        for (IField iField : iFields) {
            iFieldsMap.put(iField.getTtvXPath() + iField.getIndices(), iField);
            iFieldsMapByTTVXpath.put(iField.getTtvXPath() + iField.getValue(), iField);
        }
    }

    public void loadCompleteTree() {
        if (this.getFields() != null) {
            this.getFields().size();
        }
        if (this.getAllDescendantAssetFields() != null) {
            this.getAllDescendantAssetFields().size();
        }
        if (this.getAllDescendantAssets() != null) {
            this.getAllDescendantAssets().size();
        }
        if (this.getFieldRevisions() != null) {
            this.getFieldRevisions().size();
        }
        for (Relation r : this.getRelations()) {
            r.getTargetAsset().loadCompleteTree();
        }
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSpecKeyValuesHasChanged(boolean specKeyValuesHasChanged) {
        this.specKeyValuesHasChanged = specKeyValuesHasChanged;
    }

    public boolean getSpecKeyValuesHasChanged() {
        return this.specKeyValuesHasChanged;
    }

    public void setSpecHandlersForValidation(Set<ISpecHandler> specHandlersForValidation) {
        this.specHandlersForValidation = specHandlersForValidation;
    }

    public Set<ISpecHandler> getSpecHandlersForValidation() {
        return this.specHandlersForValidation;
    }

    public static void setPaths(Asset asset, String parentPath) {
        String path = parentPath == null ? asset.getAssetType() : parentPath + _XPATH_SPLIT + asset.getAssetType();
        asset.setPath(path);
        for (Relation r : asset.getRelations()) {
            Asset.setPaths(r.getTargetAsset(), path);
        }
    }

    private String checkAndGetEcmfXpath(String fldName) {
        String ecmfXPath = fldName;
        XPathTranslator x = new XPathTranslator();
        if (x.getType(fldName) == XPathTranslator.XPathType.TTV_XPATH) {
            ecmfXPath = x.translateTTVtoECMF(fldName);
        } else {
            String xpath;
            Map<String, String> aliasMap = FieldAliasMappingReader.getInstance().getAliasMap();
            if (aliasMap != null && (xpath = aliasMap.get(fldName)) != null && !xpath.isEmpty()) {
                ecmfXPath = xpath;
            }
        }
        return ecmfXPath;
    }

    public String getContentURI() {
        Field field = this.getField(FieldName.URL.toString());
        return field != null ? field.getValue() : null;
    }

    public String getContentFileName() {
        String contentURI = this.getContentURI();
        if (contentURI == null) {
            return null;
        }
        String filePath = contentURI;
        try {
            filePath = new URI(contentURI).getPath();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String fileName = filePath;
        try {
            fileName = new java.io.File(filePath).getName();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return fileName;
    }

    public List<Field> getFields(String xpath) {
        String ecmfXpath = this.checkAndGetEcmfXpath(xpath);
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field f : this.getFields()) {
            if (!f.getTtvXPath().equals(ecmfXpath) && !f.getTtvXPath().startsWith(ecmfXpath + _XPATH_SPLIT)) continue;
            list.add(f);
        }
        return list;
    }

    public Field getField(String xpath) {
        String ecmfXPath = this.checkAndGetEcmfXpath(xpath);
        for (Field field : this.fields) {
            if (!field.getTtvXPath().equals(ecmfXPath) || !this.isFieldWithFirstIndices(field)) continue;
            return field;
        }
        return null;
    }

    private boolean isFieldWithFirstIndices(Field field) {
        List<Integer> indices = field.getIndices();
        Integer expectedIndex = new Integer(1);
        for (Integer index : indices) {
            if (index == null || index.equals(expectedIndex)) continue;
            return false;
        }
        return true;
    }

    public abstract Asset fieldsClone();

    protected void setBasics(Asset clone) {
        clone.id = this.id;
        clone.displayId = this.displayId;
        clone.path = this.path;
        for (Field field : this.fields) {
            clone.addField(field.clone());
        }
        clone.fieldRevisions = this.fieldRevisions;
        clone.allDescendantAssetFields = new ArrayList<Field>();
        clone.allDescendantAssets = new ArrayList<Asset>();
        clone.originalAssetID = this.originalAssetID;
        clone.originalRevisionNumber = this.originalRevisionNumber;
        clone.originalRevisionChanged = this.originalRevisionChanged;
        clone.latestRevisionNumber = this.latestRevisionNumber;
        clone.isRevisionNumberUpdated = this.isRevisionNumberUpdated;
        clone.specKeyValuesHasChanged = this.specKeyValuesHasChanged;
        clone.specHandlersForValidation = this.specHandlersForValidation;
        clone.fieldRevisionsMap = this.fieldRevisionsMap;
        clone.state = this.state;
        clone.externalRevision = this.externalRevision;
        for (Relation relation : this.relations) {
            if (!(relation instanceof ParentChildRelation)) continue;
            Asset target = relation.getTargetAsset().fieldsClone();
            clone.addChild(target);
            clone.getAllDescendantAssets().addAll(target.getAllDescendantAssets());
            clone.getAllDescendantAssets().add(target);
            clone.getAllDescendantAssetFields().addAll(target.getAllDescendantAssetFields());
            clone.getAllDescendantAssetFields().addAll(target.fields);
        }
    }

    public void registerListener(ChangeListener change) {
        this.listeners.add(change);
    }

    public void unregisterListener(ChangeListener change) {
        this.listeners.remove(change);
    }

    public ArrayList<ChangeListener> getRegisteredListeners() {
        return this.listeners;
    }

    private static final class FieldTreeNodeComparator
    implements Comparator<FieldTreeNode> {
        private FieldTreeNodeComparator() {
        }

        @Override
        public int compare(FieldTreeNode o1, FieldTreeNode o2) {
            int compare = o1.getName().compareTo(o2.getName());
            if (compare == 0) {
                compare = o1.getCurrentIndex().compareTo(o2.getCurrentIndex());
            }
            return compare;
        }
    }
}

