/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class XslTranslator
implements ITranslator {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ClassLoader classLoader;
    private ObjectPool<Transformer> transformerPool;
    private static final String PROPERTY_NAME_PLUGIN_TRANSFORMERPOOL_MAXACTIVE = "plugin_transformerpool.maxactive";
    private static final String PROPERTY_NAME_PLUGIN_TRANSFORMERPOOL_MAXWAITMILLISECS = "plugin_transformerpool.maxwait";

    void createPool(InputStream xslStream, ClassLoader classLoader) {
        try {
            Properties poolProps = new Properties();
            poolProps.load(ECMFFieldBinder.class.getResourceAsStream("/objectpools.properties"));
            int maxActiveTransformers = Integer.parseInt(poolProps.getProperty(PROPERTY_NAME_PLUGIN_TRANSFORMERPOOL_MAXACTIVE));
            long maxWaitTransformers = Long.parseLong(poolProps.getProperty(PROPERTY_NAME_PLUGIN_TRANSFORMERPOOL_MAXWAITMILLISECS));
            this.transformerPool = new GenericObjectPool((PoolableObjectFactory)new PoolableTransformerFactory(xslStream, classLoader), maxActiveTransformers, 1, maxWaitTransformers);
            this.logger.info((Object)("Spec Plugin Transformers pool initialized...maxActive=" + maxActiveTransformers + " maxWait=" + maxWaitTransformers));
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception occurred creating Spec Plugin Transformers pool", (Throwable)e);
        }
    }

    @Override
    public void setXslStream(InputStream xslStream) {
        this.createPool(xslStream, this.classLoader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document translate(Document doc) throws TranslationException {
        Document document;
        this.logger.debug((Object)"In Translate");
        DocumentBuilder dBuilder = null;
        Transformer t = null;
        try {
            dBuilder = XmlUtil.borrowDocumentBuilder();
            Document docOut = dBuilder.newDocument();
            DOMResult result = new DOMResult(docOut);
            t = (Transformer)this.transformerPool.borrowObject();
            t.transform(new DOMSource(doc), result);
            document = docOut;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                XmlUtil.returnDocumentBuilder(dBuilder);
                try {
                    if (t == null) throw throwable;
                    this.transformerPool.returnObject(t);
                    throw throwable;
                }
                catch (Exception e2) {
                    this.logger.error((Object)("Error occurred giving back Transformer to Spec Plugin pool : " + e2));
                }
                throw throwable;
            }
        }
        XmlUtil.returnDocumentBuilder(dBuilder);
        try {
            if (t == null) return document;
            this.transformerPool.returnObject((Object)t);
            return document;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error occurred giving back Transformer to Spec Plugin pool : " + e));
        }
        return document;
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    private static class PoolableTransformerFactory
    extends BasePoolableObjectFactory<Transformer> {
        private InputStream xslStream;
        private ClassLoader classLoader;

        public PoolableTransformerFactory(InputStream xslStream, ClassLoader classLoader) {
            this.xslStream = xslStream;
            this.classLoader = classLoader;
        }

        public Transformer makeObject() throws Exception {
            try {
                TransformerFactory tf = XmlUtil.createTransformerFactory(this.classLoader);
                tf.setURIResolver(new ResourceResolver(this.classLoader));
                Transformer t = tf.newTransformer(new StreamSource(this.xslStream));
                return t;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new RuntimeException(e);
            }
        }

        public void passivateObject(Transformer obj) throws Exception {
            if (obj != null) {
                obj.reset();
            }
            super.passivateObject((Object)obj);
        }
    }
}

