/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;

public class CustomFieldXPathConverter {
    public static String getActualXpath(String fldXpath) {
        String[] subParts;
        if (!fldXpath.startsWith("/Fields/CustomFields/CustomField")) {
            throw new RuntimeException("Invalid xpath for custom field:" + fldXpath);
        }
        String dataType = DataTypeMappingReader.getInstance().determineDataType(fldXpath);
        if (dataType == null) {
            throw new RuntimeException("Datatype not found for custom field:" + fldXpath);
        }
        String actualXPath = dataType.equals("integer") ? fldXpath.replaceAll("@value", "IntegerValue") : (dataType.equals("float") ? fldXpath.replaceAll("@value", "FloatValue") : (dataType.equals("date") ? fldXpath.replaceAll("@value", "DatetimeValue") : (dataType.equals("time") ? fldXpath.replaceAll("@value", "TimeValue") : (dataType.equals("boolean") ? fldXpath.replaceAll("@value", "BooleanValue") : fldXpath.replaceAll("@value", "Value")))));
        String[] parts = actualXPath.split("=");
        if (parts.length > 1 && (subParts = parts[1].split("]")).length > 1) {
            String cfName = subParts[0];
            actualXPath = parts[0] + "=\"" + cfName + "\"]" + subParts[1];
        }
        return actualXPath;
    }
}

