/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.model.CustomField;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XPathTranslator;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldBinder {
    private static final Logger logger = Logger.getLogger(FieldBinder.class);
    public static final String _CUSTOMFIELD_NAME = "tns:CustomField[@name=";
    public static final String _CUSTOMFIELDS = "/tns:CustomFields";
    public static final String _CUSTOMFIELD = "tns:CustomField";
    private DocumentBuilder builder;
    private Transformer transformer;
    private static final String FIELDS = "tns:Fields";
    private static final String XMLNS_TNS_NAME = "xmlns:tns";
    private static final String XMLNS_TNS_VALUE = "http://www.tandbergtv.com/TTVSchema";
    private static final String XMLNS_XSI_NAME = "xmlns:xsi";
    private static final String XMLNS_XSI_VALUE = "http://www.w3.org/2000/XMLSchema-instance";
    private static final String XSI_SCHEMA_LOCATION_NAME = "xsi:schemaLocation";
    private static final String XSI_SCHEMA_LOCATION_VALUE = "http://www.tandbergtv.com/TTVSchema TTVSpec.xsd";
    private static final String XSLT = "com/tandbergtv/metadatamanager/util/xpath.xsl";
    private static final String PROPERTY_NAME_TRANSFORMERPOOL_MAXACTIVE = "transformerpool.maxactive";
    private static final String PROPERTY_NAME_TRANSFORMERPOOL_MAXWAITMILLISECS = "transformerpool.maxwait";
    private static ObjectPool<Transformer> transformerPool;

    public Document buildXml(List<Field> fields) {
        Document doc = null;
        try {
            this.builder = XmlUtil.borrowDocumentBuilder();
            doc = this.builder.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            XmlUtil.returnDocumentBuilder(this.builder);
        }
        Element root = doc.createElementNS(XMLNS_TNS_VALUE, FIELDS);
        root.setAttribute("xmlns", "http://www.w3.org/2000/xmlns/");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_XSI_NAME, XMLNS_XSI_VALUE);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS_TNS_NAME, XMLNS_TNS_VALUE);
        root.setAttributeNS(XMLNS_XSI_VALUE, XSI_SCHEMA_LOCATION_NAME, XSI_SCHEMA_LOCATION_VALUE);
        doc.appendChild(root);
        XPathTranslator x = new XPathTranslator();
        for (Field newField : fields) {
            this.appendFieldToDocument(newField, root, x);
        }
        return doc;
    }

    private void appendFieldToDocument(Field fieldToAppend, Element root, XPathTranslator x) {
        Field field = new Field(fieldToAppend);
        x.translateECMFtoTTV(field);
        String xpath = field.getTtvXPath();
        String attribute = "";
        if (xpath.indexOf("/@") > -1) {
            attribute = xpath.replaceFirst(".*/@", "");
            xpath = xpath.replaceFirst("/@.*", "");
        }
        String[] xpathSplit = xpath.split("/");
        List<Integer> indices = field.getIndices();
        String value = field.getValue();
        Document document = root.getOwnerDocument();
        Element parent = root;
        for (int i = 1; i < indices.size(); ++i) {
            Element node = null;
            String xpathChild = xpathSplit[i + 1];
            int index = indices.get(i);
            if (xpathChild.contains(_CUSTOMFIELD_NAME)) {
                node = (Element)parent.appendChild(document.createElementNS(XMLNS_TNS_VALUE, _CUSTOMFIELD));
                String cfName = this.extractCustomFieldName(xpathChild);
                node.setAttribute("name", cfName);
            } else {
                NodeList children = parent.getChildNodes();
                int currentIndex = 0;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    Node child = children.item(childIndex);
                    if (!(child instanceof Element) || !xpathChild.equals(child.getNodeName()) || ++currentIndex != index) continue;
                    node = (Element)child;
                    break;
                }
                while (currentIndex < index) {
                    node = document.createElementNS(XMLNS_TNS_VALUE, xpathChild);
                    parent.appendChild(node);
                    ++currentIndex;
                }
            }
            if (node == null) {
                throw new RuntimeException("Failed to create new child node for field: " + field);
            }
            parent = node;
        }
        if (!attribute.equals("")) {
            parent.setAttribute(attribute, value);
        } else {
            parent.setTextContent(value);
        }
    }

    public List<Field> extractXPaths(Document doc) {
        ArrayList<Field> fields = new ArrayList<Field>();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            this.transformer = (Transformer)transformerPool.borrowObject();
            this.transformer.transform(new DOMSource(doc), result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (this.transformer != null) {
                    transformerPool.returnObject((Object)this.transformer);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error occurred giving back Transformer to pool : " + e));
            }
        }
        String[] xpaths = sw.toString().split("#ttv#ttv#ttv#ttv#\n");
        XPathTranslator x = new XPathTranslator();
        for (String xpath : xpaths = this.handleCustomFieldXpaths(xpaths)) {
            String[] indexSplit;
            if (xpath.matches("/tns:Fields\\{[0-9]*\\}/@.*")) continue;
            Field field = new Field();
            int equalSign = xpath.indexOf("==");
            String indexedXPath = xpath.substring(0, equalSign);
            field.setTtvXPath(indexedXPath.replaceAll("\\{[0-9]*\\}", ""));
            field.setValue(xpath.substring(equalSign + 2));
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String indexStr : indexSplit = indexedXPath.split("\\{")) {
                int bracket = indexStr.indexOf("}");
                if (bracket <= -1) continue;
                indices.add(Integer.parseInt(indexStr.substring(0, bracket)));
            }
            field.setIndices(indices);
            x.translateTTVtoECMF(field);
            fields.add(field);
        }
        return fields;
    }

    private String[] handleCustomFieldXpaths(String[] xpaths) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> cfList = new ArrayList<String>();
        for (String xpath : xpaths) {
            if (xpath.contains(_CUSTOMFIELDS)) {
                cfList.add(xpath);
                continue;
            }
            list.add(xpath);
        }
        Collection<CustomField> customFields = this.getCustomFields(cfList);
        for (CustomField customField : customFields) {
            list.add(customField.constructTTVString());
        }
        return list.toArray(new String[0]);
    }

    public Collection<CustomField> getCustomFields(List<String> customFieldsXPaths) {
        HashMap<String, CustomField> customFields = new HashMap<String, CustomField>();
        for (String xpath : customFieldsXPaths) {
            CustomField customField;
            if (!xpath.contains("CustomField{")) continue;
            String[] xpathSplit = xpath.split("==");
            if (xpathSplit[0].endsWith("/@value")) {
                customField = this.getCustomField(customFields, xpathSplit[0], "@value");
                String customFieldValue = xpathSplit.length != 2 ? "" : xpathSplit[1];
                customField.setValue(customFieldValue);
                continue;
            }
            if (!xpathSplit[0].endsWith("/@name")) continue;
            customField = this.getCustomField(customFields, xpathSplit[0], "@name");
            customField.setName(xpathSplit[1]);
        }
        ArrayList<CustomField> allCustomFields = new ArrayList<CustomField>(customFields.values());
        Collections.sort(allCustomFields, new Comparator<CustomField>(){

            @Override
            public int compare(CustomField customField1, CustomField customField2) {
                Integer index1 = customField1.getCustomFieldIndex();
                Integer index2 = customField2.getCustomFieldIndex();
                return index1.compareTo(index2);
            }
        });
        this.updateTTVXPathCustomFieldIndices(allCustomFields);
        return allCustomFields;
    }

    private CustomField getCustomField(Map<String, CustomField> customFields, String xPath, String attributeKey) {
        String xPathWithoutAttribute = xPath.substring(0, xPath.lastIndexOf("/" + attributeKey));
        CustomField customField = customFields.get(xPathWithoutAttribute);
        if (customField == null) {
            customField = new CustomField(xPathWithoutAttribute);
            customFields.put(xPathWithoutAttribute, customField);
        }
        return customField;
    }

    private String extractCustomFieldName(String xpathChild) {
        String cfName = "";
        String[] o = xpathChild.split("=");
        if (o.length == 2) {
            cfName = o[1];
            cfName = cfName.replaceAll("\\]", "");
        }
        return cfName;
    }

    private void updateTTVXPathCustomFieldIndices(List<CustomField> allCustomFields) {
        HashMap<String, ArrayList<CustomField>> fieldMap = new HashMap<String, ArrayList<CustomField>>();
        for (CustomField customField : allCustomFields) {
            ArrayList<CustomField> fields = (ArrayList<CustomField>)fieldMap.get(customField.getName());
            if (fields == null) {
                fields = new ArrayList<CustomField>();
                fieldMap.put(customField.getName(), fields);
            }
            fields.add(customField);
        }
        for (String customFieldName : fieldMap.keySet()) {
            Collection customFields = (Collection)fieldMap.get(customFieldName);
            int newIndex = 1;
            for (CustomField customField : customFields) {
                customField.setTtvXPathCustomFieldIndex(newIndex++);
            }
        }
    }

    static {
        try {
            Properties poolProps = new Properties();
            poolProps.load(FieldBinder.class.getResourceAsStream("/objectpools.properties"));
            int maxActiveTransformers = Integer.parseInt(poolProps.getProperty(PROPERTY_NAME_TRANSFORMERPOOL_MAXACTIVE));
            long maxWaitTransformers = Long.parseLong(poolProps.getProperty(PROPERTY_NAME_TRANSFORMERPOOL_MAXWAITMILLISECS));
            transformerPool = new GenericObjectPool((PoolableObjectFactory)new PoolableTransformerFactory(), maxActiveTransformers, 1, maxWaitTransformers);
            logger.info((Object)"FieldBinder Transformers pool initialized...");
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred creating FieldBinder Transformers Pool", (Throwable)e);
        }
    }

    private static class PoolableTransformerFactory
    extends BasePoolableObjectFactory<Transformer> {
        private PoolableTransformerFactory() {
        }

        public Transformer makeObject() throws Exception {
            InputStream is = FieldBinder.class.getClassLoader().getResourceAsStream(FieldBinder.XSLT);
            try {
                TransformerFactory tf = XmlUtil.createTransformerFactory(FieldBinder.class.getClassLoader());
                tf.setURIResolver(new ResourceResolver());
                Transformer transformer = tf.newTransformer(new StreamSource(is));
                return transformer;
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new RuntimeException(e);
            }
        }

        public void passivateObject(Transformer obj) throws Exception {
            if (obj != null) {
                obj.reset();
            }
            super.passivateObject((Object)obj);
        }
    }
}

