/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.client.ContentClassServiceProxy;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CCExport {
    public static void handleExport(ContentClassServiceProxy proxy, String contentClassIds, String fileName, String partner) {
        if (fileName == null) {
            return;
        }
        System.out.println("===> start export ...");
        PrintWriter writer = null;
        List<String> ids = CCExport.parseIds(contentClassIds);
        try {
            File file = new File(fileName);
            writer = new PrintWriter(file);
        }
        catch (Exception ex) {
            System.out.println("Could not open export file " + fileName);
            ex.printStackTrace();
            return;
        }
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        writer.write("\n");
        writer.write("<contentclass-list>");
        writer.write("\n");
        boolean exportPartners = partner == null || !partner.equalsIgnoreCase("ignore");
        for (String ccId : ids) {
            System.out.println("Exporting Content Class with id " + ccId + "...");
            String resp = proxy.exportXml(ccId, exportPartners);
            if (resp == null) continue;
            if (resp.startsWith("Error:")) {
                System.out.println(resp);
                continue;
            }
            if (resp.startsWith("<?xml")) {
                int idx = resp.indexOf(62);
                writer.write(resp.substring(idx + 1));
                writer.write("\n");
                System.out.println("Exported.");
                continue;
            }
            System.out.println("Invalid response: " + resp);
        }
        writer.write("</contentclass-list>");
        writer.write("\n");
        writer.close();
        System.out.println("===> end export ...");
    }

    private static List<String> parseIds(String str) {
        ArrayList<String> ids = new ArrayList<String>();
        StringTokenizer tkz = new StringTokenizer(str, ", \t");
        while (tkz.hasMoreTokens()) {
            ids.add(tkz.nextToken());
        }
        return ids;
    }
}

