/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.client.CCExport;
import com.tandbergtv.cms.services.client.CCImport;
import com.tandbergtv.cms.services.client.ContentClassServiceProxy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ContentClassServiceClient {
    private static final Logger logger = Logger.getLogger(ContentClassServiceClient.class.getName());
    public static final String PROGRAM_SHORT_NAME = "com.tandbergtv.cms.services.client.ContentClassServiceClient";
    public static final String PROGRAM_VERSION_NUMBER = "1.0";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String CONTENT_CLASS_EXPORT_EXTENSION = "xml";
    public static final String DEFAULT_DATE_TIME_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    public static final DateFormat DEFAULT_DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
    private String userName = null;
    private String password = null;
    private String contentClassIds = null;
    private String file = null;
    private String serverURL = null;
    private String partner = null;
    private static Options options;

    public static void main(String[] args) {
        options = ContentClassServiceClient.createOptions();
        GnuParser parser = new GnuParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
            ContentClassServiceClient.exitWithHelp();
        }
        Option[] optionsArray = commandLine.getOptions();
        if (optionsArray.length == 0 || commandLine.hasOption("help")) {
            ContentClassServiceClient.exitWithHelp();
        }
        if (commandLine.hasOption("version")) {
            System.out.println("com.tandbergtv.cms.services.client.ContentClassServiceClient : 1.0");
            System.exit(0);
        }
        if (commandLine.hasOption("action")) {
            String action = commandLine.getOptionValue("action");
            if (ACTION_IMPORT.equalsIgnoreCase(action)) {
                ContentClassServiceClient client = new ContentClassServiceClient();
                client.doImport(commandLine);
            } else if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                ContentClassServiceClient client = new ContentClassServiceClient();
                client.doExport(commandLine);
            } else {
                System.out.println("Invalid action: " + action);
                ContentClassServiceClient.exitWithHelp();
            }
        } else {
            System.out.println("Missing action parameter");
            ContentClassServiceClient.exitWithHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImport(CommandLine commandLine) {
        this.userName = commandLine.getOptionValue("username");
        this.password = commandLine.getOptionValue("password");
        this.serverURL = commandLine.getOptionValue("serverURL");
        this.file = commandLine.getOptionValue("file");
        this.partner = commandLine.getOptionValue("partner");
        this.validateImportParameters();
        ContentClassServiceProxy proxy = null;
        try {
            proxy = new ContentClassServiceProxy(this.serverURL, this.userName, this.password);
            Response response = proxy.authenticate();
            if (Response.Status.UNAUTHORIZED.getStatusCode() == response.getStatus()) {
                System.err.println("Login failed. Cannot Export/Import.");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            System.out.println("Authentication error: " + ex.getLocalizedMessage());
            logger.log(Level.SEVERE, "Authentication error.", ex);
            System.exit(1);
        }
        finally {
            if (proxy != null) {
                proxy.close();
            }
        }
        CCImport.handleImport(proxy, this.file, this.partner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(CommandLine commandLine) {
        ContentClassServiceProxy proxy;
        this.userName = commandLine.getOptionValue("username");
        this.password = commandLine.getOptionValue("password");
        this.serverURL = commandLine.getOptionValue("serverURL");
        this.contentClassIds = commandLine.getOptionValue("contentClassIds");
        this.file = commandLine.getOptionValue("file");
        this.partner = commandLine.getOptionValue("partner");
        this.validateExportParameters();
        if (this.contentClassIds.equalsIgnoreCase("all")) {
            proxy = new ContentClassServiceProxy(this.serverURL, this.userName, this.password);
            String allIds = proxy.getAllContentClassIds();
            this.contentClassIds = allIds.substring(1, allIds.length() - 1);
        }
        proxy = null;
        try {
            proxy = new ContentClassServiceProxy(this.serverURL, this.userName, this.password);
            Response response = proxy.authenticate();
            if (Response.Status.UNAUTHORIZED.getStatusCode() == response.getStatus()) {
                System.err.println("Login failed. Cannot Export/Import.");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            System.out.println("Authentication error: " + ex.getLocalizedMessage());
            logger.log(Level.SEVERE, "Authentication error.", ex);
            System.exit(1);
        }
        finally {
            if (proxy != null) {
                proxy.close();
            }
        }
        CCExport.handleExport(proxy, this.contentClassIds, this.file, this.partner);
    }

    private void validateImportParameters() {
        if (this.userName == null) {
            System.err.println("Missing required parameter 'username'.");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.password == null) {
            System.err.println("Missing required parameter 'password'.");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.serverURL == null) {
            System.err.println("Missing required parameter 'serverURL'");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.file == null) {
            System.err.println("Missing required parameter 'file'");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.partner == null) {
            this.partner = "updateExisting";
        } else if (!(this.partner.equalsIgnoreCase("ignore") || this.partner.equalsIgnoreCase("updateExisting") || this.partner.equalsIgnoreCase("createAndUpdate"))) {
            System.err.println("Invalid partner option: " + this.partner);
            ContentClassServiceClient.exitWithHelp();
        }
    }

    private void validateExportParameters() {
        if (this.userName == null) {
            System.err.println("Missing required parameter 'username'.");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.password == null) {
            System.err.println("Missing required parameter 'password'.");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.serverURL == null) {
            System.err.println("Missing required parameter 'serverURL'");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.file == null) {
            System.err.println("Missing required parameter 'file'");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.contentClassIds == null) {
            System.err.println("Missing required parameter 'contentClassIds'.");
            ContentClassServiceClient.exitWithHelp();
        }
        if (this.partner != null && !this.partner.equalsIgnoreCase("ignore")) {
            System.err.println("The 'partner' option can only be used with 'ignore' value during export command.");
            ContentClassServiceClient.exitWithHelp();
        }
    }

    private static void exitWithHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(PROGRAM_SHORT_NAME, options);
        System.exit(1);
    }

    private static Options createOptions() {
        Options options = new Options();
        Option optionHelp = new Option("help", "print this message");
        Option optionVersion = new Option("version", "print the version information and exist");
        OptionBuilder.withArgName((String)"[import | export]");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import/export action");
        Option optionAction = OptionBuilder.create((String)"action");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import/export file path");
        Option optionFile = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"serverURL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Server Host URL, e.g., https://localhost:8443");
        Option optionServerURL = OptionBuilder.create((String)"serverURL");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User Name");
        Option optionUserName = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password");
        Option optionPassword = OptionBuilder.create((String)"password");
        OptionBuilder.withArgName((String)"contentClassIds | ALL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A list of Content Class Ids separated by ','");
        Option optionContentClassIds = OptionBuilder.create((String)"contentClassIds");
        OptionBuilder.withArgName((String)"partner");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The partner option accepts the following values: 'ignore'(Import/Export), 'updateExisting' (Import) and 'createAndUpdate'(Import)");
        Option optionProvider = OptionBuilder.create((String)"partner");
        options.addOption(optionHelp);
        options.addOption(optionVersion);
        options.addOption(optionAction);
        options.addOption(optionFile);
        options.addOption(optionServerURL);
        options.addOption(optionUserName);
        options.addOption(optionPassword);
        options.addOption(optionContentClassIds);
        options.addOption(optionProvider);
        return options;
    }
}

