/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.IContentClassService;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContentClassServiceProxy {
    private static final String DEFAULT_SERVICES_PATH_PREFIX = "/services";
    private HttpClient httpClient;
    private String authorizationHeader;
    private IContentClassService ccClient;

    public ContentClassServiceProxy(String serverURL, String userName, String password) {
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
        this.httpClient = this.createClient(userName, password);
        ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(this.httpClient);
        this.ccClient = (IContentClassService)ProxyFactory.create(IContentClassService.class, (String)(serverURL + DEFAULT_SERVICES_PATH_PREFIX), (ClientExecutor)clientExecutor);
        this.authorizationHeader = this.createAuthorizationHeader(userName, password);
    }

    public Response authenticate() {
        return this.ccClient.authenticate(this.authorizationHeader);
    }

    public void close() {
    }

    public String importXml(String xml, String partner) {
        try {
            return this.ccClient.contentClassImport(this.authorizationHeader, xml, partner);
        }
        catch (Exception ex) {
            System.out.println("Could not import XML.");
            System.out.println(xml);
            ex.printStackTrace();
            return null;
        }
    }

    public String exportXml(String contentClassId, boolean exportPartners) {
        try {
            return this.ccClient.contentClassExport(this.authorizationHeader, contentClassId, exportPartners);
        }
        catch (Exception ex) {
            System.out.println("Could not export content class " + contentClassId);
            ex.printStackTrace();
            return null;
        }
    }

    public String getAllContentClassIds() {
        try {
            return this.ccClient.getContentClassIds(this.authorizationHeader);
        }
        catch (Exception ex) {
            System.out.println("Could not get all content class ids");
            return null;
        }
    }

    private HttpClient createClient(String userId, String password) {
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        return httpClient;
    }

    private String createAuthorizationHeader(String userName, String password) {
        String encodeUserPass = userName + ":" + password;
        byte[] encodedBytes = Base64.encodeBase64((byte[])encodeUserPass.getBytes());
        return "BASIC " + new String(encodedBytes);
    }
}

