/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.services.ICustomFieldsService;
import com.tandbergtv.metadatamanager.customfield.model.CustomFields;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldsServiceClient {
    private static Logger logger = LoggerFactory.getLogger((String)CustomFieldsServiceClient.class.getName());
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String PROGRAM_SHORT_NAME = "customfields";
    public static final String PROGRAM_VERSION_NUMBER = "1.0";
    public static final String DEFAULT_DATE_TIME_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    public static final DateFormat DEFAULT_DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
    public static final String DEFAULT_SERVICES_PATH_PREFIX = "/services";
    public static final String UPGRADE_SUFFIX = "Upgraded";
    public static final String UPGRADE_MESSAGE = ": ";
    private static final String DEFAULT_CUSTOM_FIELDS_EXPORT_FILE_NAME_PREFIX = "CustomFields";
    private static final String CUSTOM_FIELDS_EXPORT_FILE_NAME_EXTENSION = "xml";

    CustomFieldsServiceClient() {
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = CustomFieldsServiceClient.createOptions();
        String userName = null;
        String password = null;
        String action = null;
        String fileName = null;
        String serverURL = null;
        boolean overwrite = true;
        boolean badInputs = false;
        try {
            HelpFormatter formatter;
            CommandLine commandLine = parser.parse(options, args);
            Option[] optionsArray = commandLine.getOptions();
            int numOptions = optionsArray.length;
            if (numOptions < 1 || commandLine.hasOption("help") || commandLine.hasOption("usage")) {
                formatter = new HelpFormatter();
                formatter.printHelp(PROGRAM_SHORT_NAME, options);
            }
            if (commandLine.hasOption("version")) {
                logger.info("customfields : 1.0");
            }
            if (commandLine.hasOption("action")) {
                action = commandLine.getOptionValue("action");
                logger.info("action : " + action);
                if (CustomFieldsServiceClient.isValidAction(action)) {
                    userName = commandLine.getOptionValue("username");
                    password = commandLine.getOptionValue("password");
                    fileName = commandLine.getOptionValue("file");
                    serverURL = commandLine.getOptionValue("serverURL");
                    logger.debug("username : " + userName);
                    logger.debug("password : " + password);
                    logger.debug("fileName : " + fileName);
                    logger.debug("serverURL : " + serverURL);
                    overwrite = true;
                    if (userName == null) {
                        System.err.println("'username' is required.");
                        badInputs = true;
                    }
                    if (password == null) {
                        System.err.println("'password' is required.");
                        badInputs = true;
                    }
                    if (serverURL == null) {
                        System.err.println("'serverURL' is required.");
                        badInputs = true;
                    }
                    if (fileName == null) {
                        if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                            fileName = CustomFieldsServiceClient.getDefaultCustomFieldsExportFileName();
                        } else {
                            System.err.println("For 'import' action, a custom fields 'file' is required.");
                        }
                    }
                    if (!badInputs) {
                        String actionMsg = "customfields 1.0 : Processing action=" + action + " with file=" + fileName;
                        logger.info(actionMsg);
                        CustomFieldsServiceClient.processAction(action, serverURL, userName, password, fileName, overwrite);
                    } else {
                        formatter = new HelpFormatter();
                        formatter.printHelp(PROGRAM_SHORT_NAME, options);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            logger.error("Exception: " + e);
        }
    }

    private static void processAction(String action, String serverURL, String userName, String password, String fileName, boolean overwrite) {
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
        HttpClient httpClient = CustomFieldsServiceClient.createClient(userName, password);
        ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(httpClient);
        ICustomFieldsService customFieldsClient = (ICustomFieldsService)ProxyFactory.create(ICustomFieldsService.class, (String)(serverURL + DEFAULT_SERVICES_PATH_PREFIX), (ClientExecutor)clientExecutor);
        Response response = customFieldsClient.authenticate(userName, password);
        logger.debug("Got authenticate response : " + response);
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            try {
                if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                    logger.info("===> start export ...");
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                    CustomFields customFields = customFieldsClient.customFieldsExport(userName, password);
                    CustomFieldsServiceClient.doExport(customFields, out);
                    logger.info("===> end export ...");
                } else if (ACTION_IMPORT.equalsIgnoreCase(action)) {
                    logger.info("===> start import ...");
                    CustomFieldsServiceClient.doImport(userName, password, fileName, overwrite, customFieldsClient);
                    logger.info("===> end import...");
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred processing action=" + action + " with fileName=" + fileName, (Throwable)e);
            }
        } else if (Response.Status.UNAUTHORIZED.getStatusCode() == response.getStatus()) {
            logger.error("Login failed. Cannot Export/Import...");
        }
        CustomFieldsServiceClient.closeClient(httpClient);
    }

    private static void doImport(String userName, String password, String fileName, boolean overwrite, ICustomFieldsService customFieldsClient) {
        logger.info("Saving custom fields from fileName = " + fileName);
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CustomFields.class});
            Unmarshaller u = jc.createUnmarshaller();
            CustomFields customFields = (CustomFields)u.unmarshal(new File(fileName));
            if (customFields != null) {
                customFields.setUserName(userName);
                customFields.setPassword(password);
                customFieldsClient.customFieldsImport(overwrite, customFields);
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred importing custom fields " + e);
        }
        logger.info("Done importing custom fields from fileName = " + fileName);
    }

    private static void doExport(CustomFields customFields, PrintWriter out) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CustomFields.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)customFields, (Writer)out);
        }
        catch (JAXBException e) {
            logger.error("Exception occured marshaling custom fields to XML : " + (Object)((Object)e), (Throwable)e);
        }
    }

    private static void closeClient(HttpClient httpClient) {
    }

    private static HttpClient createClient(String userId, String password) {
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        return httpClient;
    }

    private static String getDefaultCustomFieldsExportFileName() {
        String defaultCustomFieldsExportFileName = DEFAULT_CUSTOM_FIELDS_EXPORT_FILE_NAME_PREFIX;
        Date now = new Date();
        String datePartString = DEFAULT_DATE_TIME_FORMAT.format(now);
        defaultCustomFieldsExportFileName = defaultCustomFieldsExportFileName + "." + datePartString + "." + CUSTOM_FIELDS_EXPORT_FILE_NAME_EXTENSION;
        return defaultCustomFieldsExportFileName;
    }

    private static Options createOptions() {
        Options options = new Options();
        Option optionHelp = new Option("help", "print this message");
        Option optionVersion = new Option("version", "print the version information and exist");
        OptionBuilder.withArgName((String)"[import | export]");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import/export action");
        Option optionAction = OptionBuilder.create((String)"action");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import/export file path");
        Option optionFile = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"serverURL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Server Host URL, e.g., http://localhost:8080");
        Option optionServerURL = OptionBuilder.create((String)"serverURL");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User Name");
        Option optionUserName = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password");
        Option optionPassword = OptionBuilder.create((String)"password");
        options.addOption(optionHelp);
        options.addOption(optionVersion);
        options.addOption(optionAction);
        options.addOption(optionFile);
        options.addOption(optionServerURL);
        options.addOption(optionUserName);
        options.addOption(optionPassword);
        return options;
    }

    private static boolean isValidAction(String action) {
        boolean isValidAction = false;
        if (ACTION_IMPORT.equalsIgnoreCase(action) || ACTION_EXPORT.equalsIgnoreCase(action)) {
            isValidAction = true;
        }
        return isValidAction;
    }
}

