/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.services.client;

import com.tandbergtv.cms.data.RuleSetToSave;
import com.tandbergtv.cms.data.RuleSetsListing;
import com.tandbergtv.cms.services.IRulesService;
import com.tandbergtv.cms.services.client.OrderBasedComparator;
import com.tandbergtv.marvin.udt.TreRuleSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesServiceClient {
    private static Logger logger = LoggerFactory.getLogger((String)RulesServiceClient.class.getName());
    public static final String PROGRAM_SHORT_NAME = "csc";
    public static final String PROGRAM_VERSION_NUMBER = "1.0";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_EXPORT = "export";
    public static final String DEFAULT_RULE_SETS_EXPORT_FILE_NAME_PREFIX = "RuleSets";
    public static final String DEFAULT_RULE_SETS_EXPORT_FILE_NAME_EXTENSION = "xml";
    public static final String DEFAULT_DATE_TIME_FORMAT_STRING = "yyyyMMdd.HHmmss.SSS";
    public static final DateFormat DEFAULT_DATE_TIME_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS");
    public static final String DEFAULT_SERVICES_PATH_PREFIX = "/services";
    public static final String UPGRADE_SUFFIX = "Upgraded";
    public static final String UPGRADE_MESSAGE = "Need Upgrading some rules. Generating Upgraded Rules File: ";

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        Options options = RulesServiceClient.createOptions();
        String userName = null;
        String password = null;
        String action = null;
        String fileName = null;
        String serverURL = null;
        String[] strRuleSetIds = null;
        boolean useEnabled = false;
        ArrayList<Integer> ruleSetIds = new ArrayList<Integer>();
        boolean overwrite = false;
        boolean badInputs = false;
        try {
            HelpFormatter formatter;
            CommandLine commandLine = parser.parse(options, args);
            Option[] optionsArray = commandLine.getOptions();
            int numOptions = optionsArray.length;
            if (numOptions < 1 || commandLine.hasOption("help") || commandLine.hasOption("usage")) {
                formatter = new HelpFormatter();
                formatter.printHelp(PROGRAM_SHORT_NAME, options);
            }
            if (commandLine.hasOption("version")) {
                logger.info("csc : 1.0");
            }
            if (commandLine.hasOption("action")) {
                action = commandLine.getOptionValue("action");
                logger.info("action : " + action);
                if (RulesServiceClient.isValidAction(action)) {
                    userName = commandLine.getOptionValue("username");
                    password = commandLine.getOptionValue("password");
                    fileName = commandLine.getOptionValue("file");
                    serverURL = commandLine.getOptionValue("serverURL");
                    strRuleSetIds = commandLine.getOptionValues("ruleSetIds");
                    overwrite = commandLine.hasOption("overwrite");
                    useEnabled = commandLine.hasOption("useEnabledFlag");
                    logger.debug("username : " + userName);
                    logger.debug("password : " + password);
                    logger.debug("fileName : " + fileName);
                    logger.debug("serverURL : " + serverURL);
                    logger.debug("strRuleSetIds : " + strRuleSetIds);
                    logger.debug("overwrite : " + overwrite);
                    if (userName == null) {
                        System.err.println("'username' is required.");
                        badInputs = true;
                    }
                    if (password == null) {
                        System.err.println("'password' is required.");
                        badInputs = true;
                    }
                    if (serverURL == null) {
                        System.err.println("'serverURL' is required.");
                        badInputs = true;
                    }
                    if (fileName == null) {
                        if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                            fileName = RulesServiceClient.getDefaultRuleSetsExportFileName();
                        } else {
                            System.err.println("For 'import' action, a rule sets 'file' is required.");
                            badInputs = true;
                        }
                    }
                    if (strRuleSetIds == null || strRuleSetIds.length < 1) {
                        if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                            System.err.println("For 'export' action, one or more rule sets Ids are required.");
                            badInputs = true;
                        }
                    } else {
                        for (String strRuleSetId : strRuleSetIds) {
                            try {
                                ruleSetIds.add(Integer.parseInt(strRuleSetId));
                            }
                            catch (NumberFormatException e) {
                                String msg = "RuleSet Id needs to be an integer. " + strRuleSetId + " would be ignored.";
                                logger.warn(msg);
                            }
                        }
                    }
                    if (!badInputs) {
                        String actionMsg = "csc 1.0 : Processing action=" + action + " with file=" + fileName;
                        logger.info(actionMsg);
                        RulesServiceClient.processAction(action, serverURL, userName, password, fileName, overwrite, ruleSetIds, useEnabled);
                    } else {
                        formatter = new HelpFormatter();
                        formatter.printHelp(PROGRAM_SHORT_NAME, options);
                    }
                }
            }
        }
        catch (Exception exp) {
            logger.error("Exception occurred: ", (Throwable)exp);
        }
    }

    private static void processAction(String action, String serverURL, String userName, String password, String fileName, boolean overwrite, List<Integer> ruleSetIds, boolean useEnabled) {
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
        HttpClient httpClient = RulesServiceClient.createClient(userName, password);
        ApacheHttpClientExecutor clientExecutor = new ApacheHttpClientExecutor(httpClient);
        IRulesService rulesServiceClient = (IRulesService)ProxyFactory.create(IRulesService.class, (String)(serverURL + DEFAULT_SERVICES_PATH_PREFIX), (ClientExecutor)clientExecutor);
        Response response = rulesServiceClient.authenticate(userName, password);
        logger.debug("Got authenticate response : " + response);
        if (Response.Status.OK.getStatusCode() == response.getStatus()) {
            try {
                if (ACTION_EXPORT.equalsIgnoreCase(action)) {
                    if (ruleSetIds.size() > 0) {
                        logger.info("===> start export ...");
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        RuleSetsListing ruleSetsListing = rulesServiceClient.getRuleSets(userName, password, ruleSetIds);
                        RulesServiceClient.printRuleSets(ruleSetsListing, out);
                        logger.info("===> end export ...");
                    } else {
                        logger.info("===> No rule set ids provided for export. Nothing will be exported ...");
                    }
                } else if (ACTION_IMPORT.equalsIgnoreCase(action)) {
                    logger.info("===> start import ...");
                    RulesServiceClient.saveRuleSets(userName, password, fileName, overwrite, rulesServiceClient, useEnabled);
                    logger.info("===> end import...");
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred processing action=" + action + " with fileName=" + fileName, (Throwable)e);
            }
        } else if (Response.Status.UNAUTHORIZED.getStatusCode() == response.getStatus()) {
            logger.error("Login failed. Cannot Export/Import...");
        }
        RulesServiceClient.closeClient(httpClient);
    }

    public static void printRuleSets(RuleSetsListing ruleSetsListing, PrintWriter out) {
        for (TreRuleSet treRuleSet : ruleSetsListing.getRuleSets()) {
            logger.info("Got ruleName = " + treRuleSet.getRuleName());
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)ruleSetsListing, (Writer)out);
        }
        catch (JAXBException e) {
            logger.error("Exception occured marshaling rule sets to XML : " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveRuleSets(String userName, String password, String fileName, boolean defaultOverwrite, IRulesService rulesServiceClient, boolean useEnabled) {
        logger.info("Saving ruleSets from fileName = " + fileName);
        List ruleSets = null;
        try {
            String upgradedRulesFileName;
            fileName = upgradedRulesFileName = RulesServiceClient.upgradeFields(fileName);
            if (!upgradedRulesFileName.equals(fileName)) {
                logger.info("Saving ruleSets from upgradedRulesFileName = " + upgradedRulesFileName);
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RuleSetsListing.class});
            Unmarshaller u = jc.createUnmarshaller();
            RuleSetsListing ruleSetsListing = (RuleSetsListing)u.unmarshal(new File(fileName));
            ruleSets = ruleSetsListing.getRuleSets();
            int numRuleSetsLoaded = ruleSets.size();
            logger.info("Loaded " + numRuleSetsLoaded + " rule sets from file : " + fileName);
            OrderBasedComparator orderBasedComparator = new OrderBasedComparator();
            Collections.sort(ruleSets, orderBasedComparator);
        }
        catch (Exception e) {
            logger.error("Exception occured loading or ordering rule sets : ", (Throwable)e);
        }
        Iterator i$ = ruleSets.iterator();
        while (true) {
            if (!i$.hasNext()) {
                logger.info("Done saving ruleSets from fileName = " + fileName);
                return;
            }
            TreRuleSet treRuleSet = (TreRuleSet)i$.next();
            Integer ruleSetId = treRuleSet.getRuleSetId();
            try {
                boolean overwrite;
                boolean skipImport;
                block19: {
                    block20: {
                        logger.info("Got ruleSet with Id : " + ruleSetId);
                        skipImport = false;
                        overwrite = defaultOverwrite;
                        if (overwrite) break block19;
                        UUID uuid = treRuleSet.getUuid();
                        if (uuid == null) break block20;
                        RuleSetsListing ruleSetsListingByUuid = rulesServiceClient.getRuleSetsByUuid(userName, password, uuid.toString());
                        List ruleSetsByUuid = ruleSetsListingByUuid.getRuleSets();
                        int numRuleSets = ruleSetsByUuid.size();
                        logger.debug("Got numRuleSets = " + numRuleSets + " by UUID : " + uuid + " in target system...");
                        if (numRuleSets > 1) {
                            logger.warn("Got more than 1 RuleSets by UUID : " + uuid + " from importing ruleSetId : " + ruleSetId + " in target system." + " Check target system.");
                            logger.warn("Skipping RuleSet import...");
                            skipImport = true;
                            break block19;
                        } else {
                            if (numRuleSets == 1) {
                                logger.info("Found 1 RuleSet by UUID : " + uuid + " from importing ruleSetId : " + ruleSetId + " in target system.");
                                Console console = System.console();
                                if (console != null) {
                                    String overwriteYN = console.readLine("RuleSet with UUID : " + uuid + " already exists in target system." + " Overwrite (Y/N): ", new Object[0]);
                                    boolean userConfirmedOverwrite = false;
                                    if (overwriteYN != null && "Y".equalsIgnoreCase(overwriteYN.trim())) {
                                        logger.info("RuleSet with UUID : " + uuid + " would be overwritten in the target system.");
                                        userConfirmedOverwrite = true;
                                    }
                                    if (userConfirmedOverwrite) {
                                        overwrite = true;
                                        break block19;
                                    } else {
                                        logger.info("User did not confirm ovewrite RuleSet with UUID : " + uuid + " in the target system. Skipping this RuleSet...");
                                        skipImport = true;
                                        continue;
                                    }
                                }
                                logger.error("No console. Cannot read user inputs. Hence skipping import of this ruleSet...");
                                skipImport = true;
                                continue;
                            }
                            logger.info("No Rule Sets found with importing RuleSet's UUID : " + uuid + ". Setting overwrite to true and import...");
                            overwrite = true;
                        }
                        break block19;
                    }
                    overwrite = true;
                }
                if (!useEnabled) {
                    treRuleSet.setEnabled(Boolean.valueOf(false));
                }
                if (skipImport) continue;
                logger.info("Saving Rule Set with Id : " + ruleSetId + " UUID : " + treRuleSet.getUuid() + " overwrite : " + overwrite);
                RuleSetToSave ruleSetToSave = new RuleSetToSave();
                ruleSetToSave.setUserName(userName);
                ruleSetToSave.setPassword(password);
                ruleSetToSave.setRuleSet(treRuleSet);
                rulesServiceClient.saveRuleSet(overwrite, ruleSetToSave);
            }
            catch (Exception e) {
                if (e instanceof ClientResponseFailure) {
                    ClientResponseFailure crf = (ClientResponseFailure)e;
                    ClientResponse cr = crf.getResponse();
                    int responseStatusCode = cr.getStatus();
                    if (responseStatusCode == 401) {
                        logger.error("Cannot import rule set with Id : " + ruleSetId + " because you do not have the required permissions.");
                        continue;
                    }
                    if (responseStatusCode == 475) {
                        logger.error("Cannot import rule set with Id : " + ruleSetId + " because it's a schedulable rule set with an invalid schedule.");
                        continue;
                    }
                    if (responseStatusCode == 476) {
                        logger.error("Cannot import rule set with Id : " + ruleSetId + " because it's a schedulable rule set but it's schedule has expired.");
                        continue;
                    }
                    logger.error("Cannot import rule set with Id : " + ruleSetId + ". The server returned status code : " + responseStatusCode);
                    continue;
                }
                logger.error("Exception occured importing rule set with Id : " + ruleSetId + " : " + e, (Throwable)e);
                continue;
            }
            break;
        }
    }

    private static HttpClient createClient(String userId, String password) {
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        return httpClient;
    }

    private static void closeClient(HttpClient httpClient) {
    }

    private static boolean isValidAction(String action) {
        boolean isValidAction = false;
        if (ACTION_IMPORT.equalsIgnoreCase(action) || ACTION_EXPORT.equalsIgnoreCase(action)) {
            isValidAction = true;
        }
        return isValidAction;
    }

    private static Options createOptions() {
        Options options = new Options();
        Option optionHelp = new Option("help", "print this message");
        Option optionVersion = new Option("version", "print the version information and exist");
        OptionBuilder.withArgName((String)"[import | export]");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import/export action");
        Option optionAction = OptionBuilder.create((String)"action");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Import/export file path");
        Option optionFile = OptionBuilder.create((String)"file");
        OptionBuilder.withArgName((String)"serverURL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Server Host URL, e.g., http://localhost:8080");
        Option optionServerURL = OptionBuilder.create((String)"serverURL");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"User Name");
        Option optionUserName = OptionBuilder.create((String)"username");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Password");
        Option optionPassword = OptionBuilder.create((String)"password");
        OptionBuilder.withArgName((String)"useEnabledFlag");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"When this option is used the rule sets will be imported using the enabled status within the rule set xml.  When this option is not present the rule sets will be set to disabled upon import.");
        Option optionUseEnabledFlag = OptionBuilder.create((String)"useEnabledFlag");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Overwrite (true/false) when the Rule Set with same UUID already exists in the system");
        Option optionOverwrite = OptionBuilder.create((String)"overwrite");
        OptionBuilder.withArgName((String)"ruleSetIds");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"One or more RuleSet Ids separated by spaces");
        Option ruleSetIds = OptionBuilder.create((String)"ruleSetIds");
        options.addOption(optionHelp);
        options.addOption(optionVersion);
        options.addOption(optionAction);
        options.addOption(optionOverwrite);
        options.addOption(optionFile);
        options.addOption(optionServerURL);
        options.addOption(optionUserName);
        options.addOption(optionPassword);
        options.addOption(ruleSetIds);
        options.addOption(optionUseEnabledFlag);
        return options;
    }

    private static String getDefaultRuleSetsExportFileName() {
        String defaultRuleSetsExportFileName = DEFAULT_RULE_SETS_EXPORT_FILE_NAME_PREFIX;
        Date now = new Date();
        String datePartString = DEFAULT_DATE_TIME_FORMAT.format(now);
        defaultRuleSetsExportFileName = defaultRuleSetsExportFileName + "." + datePartString + "." + DEFAULT_RULE_SETS_EXPORT_FILE_NAME_EXTENSION;
        return defaultRuleSetsExportFileName;
    }

    private static String upgradeFields(String filename) throws Exception {
        String resultFile = filename;
        File xmlFile = new File(filename);
        String upgradedRulesFileName = filename;
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(xmlFile));
            String line = null;
            boolean needsUpgrade = false;
            while ((line = br.readLine()) != null) {
                if (line.contains("<fieldLeft>/Fields/OSVOD/AssociationId</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/OSVOD/AssociationId</fieldLeft>", "<fieldLeft>/Fields/OSVOD/AssociationIds/AssociationId</fieldLeft>");
                }
                if (line.contains("<value>/Fields/OSVOD/AssociationId</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/OSVOD/AssociationId</value>", "<value>/Fields/OSVOD/AssociationIds/AssociationId</value>");
                }
                if (line.contains("<fieldLeft>/Fields/OSVOD/ViewingWindow</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/OSVOD/ViewingWindow</fieldLeft>", "<fieldLeft>/Fields/OSVOD/ViewingWindows/ViewingWindow</fieldLeft>");
                }
                if (line.contains("<value>/Fields/OSVOD/ViewingWindow</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/OSVOD/ViewingWindow</value>", "<value>/Fields/OSVOD/ViewingWindows/ViewingWindow</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail</value>", "<value>/Fields/Avails/Avail</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeOne</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeOne</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeOne</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeOne</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeOne</value>", "<value>/Fields/Avails/Avail/TimeCodeOne</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeTwo</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeTwo</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeTwo</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeTwo</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeTwo</value>", "<value>/Fields/Avails/Avail/TimeCodeTwo</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeThree</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeThree</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeThree</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeThree</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeThree</value>", "<value>/Fields/Avails/Avail/TimeCodeThree</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/TimeCodeFour</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/TimeCodeFour</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/TimeCodeFour</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/TimeCodeFour</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/TimeCodeFour</value>", "<value>/Fields/Avails/Avail/TimeCodeFour</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Id</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Id</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Id</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Id</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Id</value>", "<value>/Fields/Avails/Avail/Id</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Scope</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Scope</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Scope</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Scope</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Scope</value>", "<value>/Fields/Avails/Avail/Scope</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Type</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Type</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Type</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Type</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Type</value>", "<value>/Fields/Avails/Avail/Type</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Avail/Position</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Avail/Position</fieldLeft>", "<fieldLeft>/Fields/Avails/Avail/Position</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Avail/Position</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Avail/Position</value>", "<value>/Fields/Avails/Avail/Position</value>");
                }
                if (line.contains("<fieldLeft>/Fields/Language/@value</fieldLeft>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<fieldLeft>/Fields/Language/@value</fieldLeft>", "<fieldLeft>/Fields/Languages/Language/@value</fieldLeft>");
                }
                if (line.contains("<value>/Fields/Language/@value</value>")) {
                    needsUpgrade = true;
                    line = line.replaceAll("<value>/Fields/Language/@value</value>", "<value>/Fields/Languages/Language/@value</value>");
                }
                sb.append(line);
            }
            if (needsUpgrade) {
                upgradedRulesFileName = RulesServiceClient.getUpgradedRulesFileName(filename);
                logger.info(UPGRADE_MESSAGE + upgradedRulesFileName);
                xmlFile = new File(upgradedRulesFileName);
                resultFile = upgradedRulesFileName;
            }
            bw = new BufferedWriter(new FileWriter(xmlFile));
            bw.write(sb.toString());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred closing BufferedReader or BufferedWriter: ", (Throwable)e);
            }
        }
        return resultFile;
    }

    private static String getUpgradedRulesFileName(String fileName) {
        String extension;
        int indexOfDotXML;
        String upgradedRulesFileName = fileName;
        if (fileName != null && (indexOfDotXML = fileName.lastIndexOf(extension = ".xml")) > 0) {
            String fileNamePreExtension = fileName.substring(0, indexOfDotXML);
            upgradedRulesFileName = fileNamePreExtension + "." + UPGRADE_SUFFIX + extension;
        }
        return upgradedRulesFileName;
    }
}

