/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.title.basicsearch;

import com.tandbergtv.cms.title.basicsearch.BasicSearchFieldValidator;
import com.tandbergtv.cms.title.basicsearch.InvalidBasicSearchPathException;
import com.tandbergtv.cms.title.search.entities.BasicSearchField;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicSearchFieldProvider {
    public static final String SEARCH_FLD_DEF_FILE = "searchFields.xml";
    public static final String SERIES_SEARCH_FLD_DEF_FILE = "seriesSearchFields.xml";
    public static final String BSEARCH_FILE_DIRECTORY = "conf" + File.separator + "contentMgmt";
    public static final String BSEARCH_FILE_PATH = BSEARCH_FILE_DIRECTORY + File.separator + "searchFields.xml";
    public static final String BSEARCH_FILE_PATH_SERIES = BSEARCH_FILE_DIRECTORY + File.separator + "seriesSearchFields.xml";
    public static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String RESOURCE_BUNDLE_BASE_NAME = "SearchFieldNames";
    private static final String SERIES_RESOURCE_BUNDLE_BASE_NAME = "SeriesSearchFieldNames";
    private static final String RESOURCE_BUNDLE_FULL_PATH = "com/tandbergtv/cms/title/basicsearch/SearchFieldNames";
    private static final String SERIES_RESOURCE_BUNDLE_FULL_PATH = "com/tandbergtv/cms/title/basicsearch/SeriesSearchFieldNames";
    private static final Logger logger = Logger.getLogger(BasicSearchFieldProvider.class);

    public static List<BasicSearchField> getSearchFieldBase(Locale locale, CriteriaMode criteriaMode) throws InvalidBasicSearchPathException {
        File searchFieldsFile;
        String fldResFullPath;
        String fldDefFile;
        String installFolder = System.getProperty(PRODUCT_DIR);
        if (criteriaMode.equals((Object)CriteriaMode.EPISODE)) {
            fldDefFile = SEARCH_FLD_DEF_FILE;
            fldResFullPath = RESOURCE_BUNDLE_FULL_PATH;
            searchFieldsFile = new File(installFolder + File.separator + BSEARCH_FILE_PATH);
        } else {
            fldDefFile = SERIES_SEARCH_FLD_DEF_FILE;
            fldResFullPath = SERIES_RESOURCE_BUNDLE_FULL_PATH;
            searchFieldsFile = new File(installFolder + File.separator + BSEARCH_FILE_PATH_SERIES);
        }
        ArrayList<BasicSearchField> searchFields = new ArrayList<BasicSearchField>();
        try {
            ResourceBundle bundle;
            Document doc;
            URL schemaUrl = BasicSearchFieldProvider.class.getResource("basicsearch.xsd");
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            DocumentBuilderFactory dbmFactory = DocumentBuilderFactory.newInstance();
            dbmFactory.setSchema(schema);
            DocumentBuilder builder = dbmFactory.newDocumentBuilder();
            if (searchFieldsFile.exists()) {
                doc = builder.parse(searchFieldsFile);
                bundle = BasicSearchFieldProvider.getResourceBundle(locale, criteriaMode);
            } else {
                URL fileUrl = BasicSearchFieldProvider.class.getResource(fldDefFile);
                InputStream is = fileUrl.openStream();
                doc = builder.parse(is);
                bundle = ResourceBundle.getBundle(fldResFullPath, locale);
            }
            NodeList nodes = doc.getElementsByTagName("mdmsearchfield");
            String invalidXpath = "";
            for (int i = 0; i < nodes.getLength(); ++i) {
                String displayName;
                Element e = (Element)nodes.item(i);
                String assetType = e.getAttribute("assetType");
                String xpath = e.getAttribute("xpath");
                String displayNameKey = e.getAttribute("displayName");
                try {
                    displayName = bundle.getString(displayNameKey);
                }
                catch (MissingResourceException ex) {
                    logger.error("ResourceBundle for basic search is missing: " + displayNameKey);
                    displayName = "!" + displayNameKey + "!";
                }
                BasicSearchField basicField = new BasicSearchField(assetType, xpath, displayName);
                boolean validField = BasicSearchFieldValidator.validateBasicField(basicField, criteriaMode);
                if (validField) {
                    searchFields.add(basicField);
                    continue;
                }
                invalidXpath = !invalidXpath.isEmpty() ? invalidXpath + " , " + basicField.getXpath() : invalidXpath + " " + basicField.getXpath();
            }
            if (!invalidXpath.isEmpty()) {
                throw new InvalidBasicSearchPathException("Invalid xpath: " + invalidXpath);
            }
        }
        catch (InvalidBasicSearchPathException e) {
            logger.error("InvalidBasicSearchPathException.", e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error while looking up basic search fields.", e);
            return new ArrayList<BasicSearchField>();
        }
        return searchFields;
    }

    private static ResourceBundle getResourceBundle(Locale locale, CriteriaMode criteriaMode) throws MalformedURLException {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File directory = new File(installFolder + File.separator + BSEARCH_FILE_DIRECTORY);
        URL[] urls = new URL[]{directory.toURL()};
        URLClassLoader aUrlCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        if (criteriaMode.equals((Object)CriteriaMode.EPISODE)) {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, locale, aUrlCL);
        }
        return ResourceBundle.getBundle(SERIES_RESOURCE_BUNDLE_BASE_NAME, locale, aUrlCL);
    }
}

