/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.title.basicsearch;

import com.tandbergtv.cms.title.basicsearch.InvalidBasicSearchPathException;
import com.tandbergtv.cms.title.search.entities.BasicSearchField;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;

public class BasicSearchFieldValidator {
    public static boolean validateBasicField(BasicSearchField basicField, CriteriaMode criteriaMode) throws InvalidBasicSearchPathException {
        UISpecification spec = BasicSearchFieldValidator.getSpecification(criteriaMode);
        List<TitleConf> allConfs = spec.getAllTitleConf();
        boolean valid = true;
        for (TitleConf conf : allConfs) {
            if (!BasicSearchFieldValidator.isFound(conf, basicField.getAssetType(), criteriaMode)) continue;
            Variable v = conf.getMetadataVariableByXPath(basicField.getXpath());
            if (v == null) {
                valid = false;
                continue;
            }
            if (!(v instanceof ComplexVariable)) continue;
            basicField.setComplex(true);
        }
        return valid;
    }

    private static boolean isFound(TitleConf conf, String assetType, CriteriaMode uiCriteraMode) {
        if (conf.getName().equals(conf.getPath())) {
            if (conf.getName().equals(assetType)) {
                return true;
            }
        } else {
            if (conf.getPath().equals(assetType)) {
                return true;
            }
            if (uiCriteraMode.equals((Object)CriteriaMode.EPISODE)) {
                assetType = "PACKAGE/" + assetType;
                if (conf.getPath().equals(assetType)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static UISpecification getSpecification(CriteriaMode criteriaMode) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager specManager = registry.lookup(ISpecificationManager.class);
        if (criteriaMode.equals((Object)CriteriaMode.EPISODE)) {
            return specManager.getUISpecification(UISpecification.Type.PACKAGE);
        }
        return specManager.getUISpecification(UISpecification.Type.SERIES);
    }
}

