#!/bin/sh
#
CONF=OOB_Configurations
AMI=AMI_Resourcetype
CACS=CACS_Resourcetype
VMX=VerimatrixOMI
UTIL=Utilities_Resourcetype
VMXCK=Verimatrix_Create_Key
VF=VARIABLE_Resourcetype
ENVIVIO=ENVIVIO_Resourcetype
CP=Content_Processing_Workflows
DIST=Distribution_Workflows
PURGE=Purge_Workflows
RPURGE=Remote_Purge_Workflows
EPURGE=Emergency_Purge_Workflows
CL30=CL30META_Plugin
CL11=CL11META_Plugin
MSMWVER=msmw

JOBS_DIR=/home/autobuild
HOME_DIR="$PWD"
DEPLOY_SCRIPT="$HOME_DIR/scripts/deploy_oob.py"
CONFIGURE_SCRIPT="$HOME_DIR/scripts/OOBConfigure.sh"
DBSYNC_DIR="$HOME_DIR/scripts/dbsync"

DATE=`date +%Y%m%d_%H%M`
BUILD_DIR=${DATE}_MSMWBUILD20
PROJ=msmw
VER=2.0.000.$1
RELEASE_DIR="/var/www/html/rpms/oob-build/msmw/$BUILD_DIR"
TMPDIR="/tmp/$BUILD_DIR"
TAR_NAME="$RELEASE_DIR/$PROJ-$VER.tar.gz"
TAR_ARCHIVE_NAME="$HOME_DIR/$PROJ-$VER.tar.gz"

mkdir -p $TMPDIR

declare -a JOBS=($CONF $AMI $CACS $VMX $UTIL $VMXCK $VF $ENVIVIO $CP $DIST $PURGE $RPURGE $EPURGE $CL30 $CL11 $MSMWVER)

cd $JOBS_DIR

for job in "${JOBS[@]}"
do
	cp -p `ls -tr | grep -e "[0-9]_$job" | tail -1`/*RPM/*.rpm $TMPDIR 2>/dev/null || true
done

cp -p "$DEPLOY_SCRIPT" "$CONFIGURE_SCRIPT" $TMPDIR
cp -r "$DBSYNC_DIR" $TMPDIR

find $TMPDIR -name "*.py" -exec chmod +x {} \;
find $TMPDIR -name "*.sh" -exec chmod +x {} \;

mkdir -p $RELEASE_DIR
cd "$TMPDIR/.."
mv $BUILD_DIR $PROJ-$VER
mkdir -p $RELEASE_DIR
tar czf "$TAR_ARCHIVE_NAME" $PROJ-$VER
echo "tar file $TAR_ARCHIVE_NAME"
cp "$TAR_ARCHIVE_NAME" $TAR_NAME
#tar czf $TAR_NAME $PROJ-$VER
echo "tar file $TAR_NAME"
rm -rf $TMPDIR


