#!/usr/bin/env python
import cx_Oracle

class BaseClass(object):
	#connection = cx_Oracle.connect("wfs/Wf$1234@dbserver")
	#cursor = connection.cursor()
	connection = None
	cursor = None
	
	def add(self, *args):
		if type(args[0]) == type(tuple()):
			args = args[0]
		if self.checkExistence(args):
			return False
		else:
			id_ = self.getNextId()
			return self.insert(id_, args)
	
	def checkExistence(self, *args):
		pass
	
	def insert(self, *args):
		pass
	
	def getNextId(self):
		pass
	
	def execute(self, statement):
		self.cursor.execute(statement)
		
	def fetchall(self):
		return self.cursor.fetchall()
	
	def _export(self):
		pass
	
	def export(self, outputFile):
		#print self.selectStatement
		try:
			self.cursor.execute(self.selectStatement)
			rows = self.fetchall()
			
			output = self.columns + "\n"
			for row in rows:
				output += "\t".join(self.noneToNull(row)) + "\n"
		
			print output
			f = file(outputFile, "w")
			f.write(output.strip())
			f.close()
		except Exception, e:
			print e
                   		
	def importFromFile(self, tdf):
		"""
		tdf=Tab Delimited File
		First line, which has the header for the columns, is ignored.
		"""
		try:
			lines = file(tdf, "r").readlines()[1 : ]
		except IOError, e:
			print e
			return
		for line in lines:
			fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
			fields = map(lambda s : ["", s][s != "null"], fields)
			self.add(tuple(fields))
			
			
	def noneToNull(self, row):
		return map(lambda l : [str(l), "null"][l == None], row)
	
	def commit(self):
		print "Successfully inserted.  Committing."
		self.connection.commit()
		return True
	
	def rollback(self):
		print "Failed to insert rows.  Rolling back."
		self.connection.rollback()
		return False

	def setSelectStatement(self):
		self.selectStatement = "SELECT %s FROM %s" % (self.columns, self.table)
		
	def replaceAll(self, text, dic):
   	 for i, j in dic.iteritems():
    		text = text.replace(i, j)
 	 return text
	
	@staticmethod
	def setConnection(connection):
		BaseClass.connection = connection
		BaseClass.cursor = connection.cursor()