#!/usr/bin/env python
import BaseClass
import Partners

class ContentClassPartners(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
	
		self.columns = "PROVIDERID, CONTENTCLASSNAME"
		self.selectStatement = "SELECT P.PROVIDERID AS PROVIDERID, CC.NAME AS CONTENTCLASSNAME "\
			"FROM PMM_CONTENT_CLASS_PARTNER CCP "\
  			"JOIN PMM_CONTENT_CLASS CC "\
     			"ON (CCP.CONTENT_CLASS_ID = CC.ID) "\
	 		"JOIN PMM_PARTNER P "\
    			"ON (CCP.PARTNER_ID = P.ID_)"
	
	def checkExistence(self, data):
		"""checkExistence(providerId, contentClassName)"""
		self.partnerId = Partners.Partners().checkExistence((None, None, data[0]))
		self.cursor.execute("SELECT ID FROM PMM_CONTENT_CLASS WHERE NAME='%s'" % data[1])
		self.contentClassId = self.cursor.fetchall()[0][0]
		
		self.cursor.execute("SELECT * FROM PMM_CONTENT_CLASS_PARTNER WHERE CONTENT_CLASS_ID=%s AND PARTNER_ID=%s" % (self.contentClassId, self.partnerId))
		if len(self.cursor.fetchall()):
			return True
		else:
			return False
		
	def getNextId(self):
		return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO PMM_CONTENT_CLASS_PARTNER (CONTENT_CLASS_ID, PARTNER_ID) VALUES %s" % str(tuple([self.contentClassId, self.partnerId]))
			print statement 
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

def main():
	ccp = ContentClassPartners()
	ccp.export("/tmp/ccp.tdf")
	
if __name__ == "__main__":
	main()