#!/usr/bin/env python
import BaseClass
import CustomFieldsGroups

class CustomFields(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, GROUP_NAME, ASSET_PATH, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, DISPLAY_NAME, MULTIVALUE, FIELD_TYPE"
	
		self.selectStatement = "SELECT CF.NAME, CFG.DISPLAY_NAME AS GROUP_NAME, CFG.ASSET_PATH, CF.DATA_TYPE, CF.JOB_PARAMETER, "\
			"CF.JOB_SCHEDULE_PARAMETER, CF.DISPLAY_NAME, CF.MULTIVALUE, CF.FIELD_TYPE "\
			"FROM MDM_CUSTOM_FIELD CF "\
  			"JOIN MDM_CUSTOM_FIELD_GROUP CFG "\
     		"ON (CF.GROUP_ID = CFG.GROUP_ID)"
	
	def checkExistence(self, data):
		fieldName = data[0]
		self.groupId = self.getGroupId(data[1], data[2])
		self.cursor.execute("SELECT CUSTOM_FIELD_ID FROM MDM_CUSTOM_FIELD WHERE NAME='%s' AND GROUP_ID=%s" % (fieldName, self.groupId))
		if len(self.cursor.fetchall()):
			return True
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT WFS.MDM_CUSTOM_FIELD_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO MDM_CUSTOM_FIELD (CUSTOM_FIELD_ID, NAME, GROUP_ID, DATA_TYPE, JOB_PARAMETER, JOB_SCHEDULE_PARAMETER, "\
			"DISPLAY_NAME, MULTIVALUE, FIELD_TYPE) VALUES %s" % str(tuple([id_, data[0], self.groupId] + list(data[3:])))
			print statement 
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def getGroupId(self, *data):
		"""getGroupId(groupName, assetPath)"""
		return CustomFieldsGroups.CustomFieldsGroups().checkExistence(data)
	
	def getCustomFields(self):
		"""select cf.name, cfg.display_name as GROUP_NAME, cfg.asset_path, cf.data_type, cf.job_parameter, cf.JOB_SCHEDULE_PARAMETER, cf.display_name, cf.multivalue, cf.field_type
		from mdm_custom_field cf
		join mdm_custom_field_group cfg
  			on (cf.group_id = cfg.group_id)"""
		

def main():
	cf = CustomFields()
	#cf.add("Test_Script_Field", "testscript", "PACKAGE/PREVIEW", "String", "N", "N", "Test Script Field", "N", 1)
	cf.export("/tmp/cf.tdf")
	
if __name__ == "__main__":
	main()