#!/usr/bin/env python
import BaseClass

import uuid

class CustomFieldsGroups(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "DISPLAY_NAME, ASSET_PATH, UUID"
		self.table = "MDM_CUSTOM_FIELD_GROUP"
		
		self.setSelectStatement()
	
	
	def checkExistence(self, data):
		groupName = data[0]
		assetPath = data[1]
		self.cursor.execute("SELECT GROUP_ID FROM MDM_CUSTOM_FIELD_GROUP WHERE DISPLAY_NAME='%s' AND ASSET_PATH='%s'" % (groupName, assetPath))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT WFS.MDM_CUSTOM_FIELD_GROUP_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		if len(data) == 3:
			u = data[2]
		else:
			u = self.generateUUID(data[0], data[1])
		try:
			statement = "INSERT INTO MDM_CUSTOM_FIELD_GROUP (GROUP_ID, DISPLAY_NAME, ASSET_PATH, UUID) VALUES %s" % str(tuple([id_] + list(data[:2]) + [u]))
			print statement 
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
			
	def generateUUID(self, *data):
		return str(uuid.uuid5(uuid.NAMESPACE_DNS, str(data)))
	
def main():
	cfg = CustomFieldsGroups()
	#cfg.add("testscript", "PACKAGE/PREVIEW")
	
	cfg.export("/tmp/cfg.tdf")
	
if __name__ == "__main__":
	main()