#!/usr/bin/env python
import BaseClass

import os
import os.path
import sys
import xml.dom.minidom

def exportContentClassesAndRules(options):
	username = options.cmsUser
	password = options.cmsPassword
	exportDirectory = options.directory
	cmsIP = options.cmsHost
	cmsPort = options.cmsPort
	
	ccXML = os.path.join(exportDirectory, "ContentClasses.xml")
	rsXML = os.path.join(exportDirectory, "RuleSets.xml")
	
	classpathSep = [";", ":"]["linux" in sys.platform]
	classpath = classpathSep.join([
		os.path.join("..", "csc"), 
		os.path.join("..", "csc", "dist", "cms_services_client.jar"),
		os.path.join("..", "csc", "lib", "*")
	])
	
	print os.popen("java -classpath %s "\
				"com.tandbergtv.cms.services.client.ContentClassServiceClient "\
				"-action export -serverURL https://%s:%s -username %s -password %s "\
				"-file %s -contentClassIds all" % (
					classpath, cmsIP, cmsPort, username, password, ccXML), "r").read()
	print os.popen("java -classpath %s "\
				"com.tandbergtv.cms.services.client.RulesServiceClient "\
				"-action export -serverURL https://%s:%s -username %s -password %s "\
				"-file %s -ruleSetIds -101" % (
					classpath, cmsIP, cmsPort, username, password, rsXML), "r").read()
def exportRCS(options, directory):
   dsn = cx_Oracle.makedsn(options.databaseHost, options.databasePort, options.databaseSid)
   connection = cx_Oracle.connect(options.rcsdatabaseUser, options.rcsdatabasePassword, dsn)
   cursor = connection.cursor()
   exports = [
			"RCSConfigSetting",
			"RCSEPGProvider",
			"RCSMetadata",
			"RCSRMConfig",
			"RCSRMLineup",
			"RCSRTC",
			"RCSRTCpool",
			"RCSTrialuse"
			 ]
   map(lambda className : __import__(className).__getattribute__(className)().export("%s/%s.tdf" % (directory, className)), exports)
   return
  
def exportME(options, directory):
   exports = [
				"MESubsProfile",
				"MESubsProfileParameter",
				"MeFieldDefinition",
				"MeIdentifierCriteria",
				"MeEnhancedField"
			 ]
   map(lambda className : __import__(className).__getattribute__(className)().export("%s/%s.tdf" % (directory,className)), exports)
   return
  
def exportSeries(options, directory):
	cmsIP = options.cmsHost
	print os.popen("chown -R nobody:nobody  %s" % (directory), "r").read()
	print os.popen("java -jar ImportExport.jar ExportSeries %s  %s" % (cmsIP, directory), "r").read()
   
  
def exportSites(options, directory):
   exports = [
				"Sites",
				"SiteTimedDistribution",
				"SiteTimedDistributionRuleParameters",
				"SiteTimedDistributionJobSchedule",
				"SiteTimedDistributionAssociatedEntities",
				"SiteTimerQrtzJob",
				"SiteTimerQrtzTriggers",
				"SitesLink",
				"SiteParameters",
				"SiteMonitoringPlugins"
			 ]
   map(lambda className : __import__(className).__getattribute__(className)().export("%s/%s.tdf" % (directory,className)), exports)
   return
  
def exportMSO(cmsIP,options, directory):
	print cmsIP
   	exportsAPI = [
		"MSO",
	]
   	map(lambda className : __import__(className).__getattribute__(className)().export(cmsIP,"%s/%s.xml"
			% (directory, className)), exportsAPI)
   	exportsAPI = [
		"MSOSites",
	]
   	map(lambda className : __import__(className).__getattribute__(className)().export("%s/%s.tdf"
			% (directory, className)), exportsAPI)
   	return

def main(options):
	exportDirectory = options.directory
	cmsIP = options.cmsHost
	
	if not os.path.exists(os.path.join(exportDirectory, "rcs")):
		os.makedirs(os.path.join(exportDirectory, "rcs"))
	
	exportRCS(options, os.path.join(exportDirectory, "rcs"))
	
	if not os.path.exists(os.path.join(exportDirectory, "ME")):
		os.makedirs(os.path.join(exportDirectory, "ME"))
	exportME(options, os.path.join(exportDirectory, "ME"))
	
	if not os.path.exists(os.path.join(exportDirectory, "Series")):
		os.makedirs(os.path.join(exportDirectory, "Series"))
	exportSeries(options, os.path.join(exportDirectory, "Series/"))
	
	if not os.path.exists(os.path.join(exportDirectory, "Sites")):
		os.makedirs(os.path.join(exportDirectory, "Sites"))
	exportSites(options, os.path.join(exportDirectory, "Sites"))
	
	if not os.path.exists(os.path.join(exportDirectory, "MSO")):
		os.makedirs(os.path.join(exportDirectory, "MSO"))
	exportMSO(cmsIP,options, os.path.join(exportDirectory, "MSO"))
				
	exports = [
		"LookupKeys",
		"LookupKeysAssetType",
		"Partners",
		"PartnerProperties",
		"SelectorKeys",
		"CustomFieldsGroups",
		"CustomFields",
		"Resources",
		"ResourceGroupMembership",
		"ContentClassPartners",
		"Rulesets"
	]
	
	if not os.path.exists(exportDirectory):
		os.makedirs(exportDirectory)
	
	map(lambda className : __import__(className).__getattribute__(className)().export("%s/%s.tdf"
		% (exportDirectory, className)), exports)

	exportContentClassesAndRules(options)
	
def usage():
	return "Usage: %prog [options]"

if __name__ == "__main__":
	import optparse
	import cx_Oracle
	
	parser = optparse.OptionParser(usage=usage())
	parser.add_option("-d", "--directory", dest="directory", metavar="directory", default="cmsexport", help="Directory to output the exported files in.")
	parser.add_option("--cms-host", dest="cmsHost", metavar="host", default="watchpoint-app", help="Hostname/IP of the CMS to export.")
	parser.add_option("--cms-port", dest="cmsPort", metavar="port", default="8443", help="Port of the CMS to export.")
	parser.add_option("--cms-user", dest="cmsUser", metavar="user", default="admin", help="CMS username.")
	parser.add_option("--cms-password", dest="cmsPassword", metavar="password", default="admin", help="CMS password.")
	
	parser.add_option("--database-host", dest="databaseHost", metavar="host", default="dbserver", help="Hostname/IP of the database to export.")
	parser.add_option("--database-port", dest="databasePort", metavar="port", default=1521, help="Port of the database to export.")
	parser.add_option("--database-sid", dest="databaseSid", metavar="sid", default="ttv", help="Database SID.")
	parser.add_option("--database-user", dest="databaseUser", metavar="user", default="wfs", help="Database username.")
	parser.add_option("--database-password", dest="databasePassword", metavar="password", default="Wf$1234", help="Database password.")
	
	parser.add_option("--rcs-database-user", dest="rcsdatabaseUser", metavar="rcsuser", default="rcs", help="RCS Database username.")
	parser.add_option("--rcs-database-password", dest="rcsdatabasePassword", metavar="rcspassword", default="RcS1234", help="RCS Database password.")
	
	options, args = parser.parse_args()
	
	dsn = cx_Oracle.makedsn(options.databaseHost, options.databasePort, options.databaseSid)
	BaseClass.BaseClass.setConnection(cx_Oracle.connect(options.databaseUser, options.databasePassword, dsn))
	main(options)
