#!/usr/bin/env python
import BaseClass
import os
import fnmatch
import time
import urllib2
import sys

def importContentClassesAndRules(options):
	username = options.cmsUser
	password = options.cmsPassword
	importDirectory = options.directory
	cmsIP = options.cmsHost
	cmsPort = options.cmsPort
	
	print os.popen("java -classpath ../csc:../csc/dist/cms_services_client.jar:../csc/lib/* "\
				"com.tandbergtv.cms.services.client.ContentClassServiceClient "\
				"-action import -serverURL https://%s:%s -username %s -password %s "\
				"--file %s/ContentClasses.xml -partner ignore" % (
					cmsIP, cmsPort, username, password, importDirectory), "r").read()
	print os.popen("java -classpath ../csc:../csc/dist/cms_services_client.jar:../csc/lib/* "\
				"com.tandbergtv.cms.services.client.RulesServiceClient "\
				"-action import -serverURL https://%s:%s -username %s -password %s "\
				"--file %s/RuleSets.xml" % (
					cmsIP, cmsPort, username, password, importDirectory), "r").read()

def configReplaceParams(directory, targetDir, params):
	abspath = os.path.abspath(directory)
	for path, dirs, files in os.walk(abspath):
		for filename in fnmatch.filter(files, "*"):
			if not filename.startswith('.svn'):
				filepath = os.path.join(path, filename)
				with open(filepath) as f:
					s = f.read()
				'''Replacing parameters isn't implemented yet'''
				#if not '\0' in s:
				#	for param in params:
				#		s = s.replace("${"+param["NAME"]+"}",param["VALUE"])
				saveFilepath = targetDir + filepath[filepath.index(abspath)+len(abspath):]
				print saveFilepath
				with open(saveFilepath, "w") as f:
					f.write(s)

def setupRCS(options, directory):
	dsn = cx_Oracle.makedsn(options.databaseHost, options.databasePort, options.databaseSid)
	connection = cx_Oracle.connect(options.rcsdatabaseUser, options.rcsdatabasePassword, dsn)
	cursor = connection.cursor()
	
	imports = [
			"RCSEPGProvider",
			"RCSMetadata",
			"RCSConfigSetting",
			"RCSEPGProvider",
			"RCSRMConfig",
			"RCSRMLineup",
			"RCSRTCpool",
			"RCSRTC",
			"RCSTrialuse"
			]
	
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), imports)
	
	return

def setupME(options, directory):
		
	imports = [
			"MESubsProfile",
			"MESubsProfileParameter",
			"MeFieldDefinition",
			"MeIdentifierCriteria",
			"MeEnhancedField"
			]
	
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), imports)
	
	print map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), imports)
	
	return

def importSeries(options, directory):
	cmsIP = options.cmsHost
	print os.popen("java -jar ImportExport.jar ImportSeries %s  %s" % (cmsIP, directory), "r").read()

def setupSites(options, directory):
		
	imports = [
			"Sites",
			"SiteTimedDistribution",
			"SiteTimedDistributionRuleParameters",
			"SiteTimedDistributionJobSchedule",
			"SiteTimedDistributionAssociatedEntities",
			"SiteTimerQrtzJob",
			"SiteTimerQrtzTriggers",
			"SitesLink",
			"SiteParameters",
			"SiteMonitoringPlugins"
			]
	
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), imports)
	
	print map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), imports)
	
	return
def setupMSO(cmsIP,options, directory):
	print cmsIP 
	importsAPI = [
		"MSO"
	]
	map(lambda className : __import__(className).__getattribute__(className)().importAPI(cmsIP,"%s/%s.xml"
		% (directory, className)), importsAPI)
	
	""" MSO-Sites associations has to be imported only after MSO's and Sites are imported, and hence a separate command for it"""
	importsAPI = [
		"MSOSites"
	]
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (directory, className)), importsAPI)
	
	return

def setupCMLicense(cmsIP,options, directory):
	print cmsIP
	print options
	print directory
	importsAPI = [
			"CMLicense"
			]
	
	map(lambda className : __import__(className).__getattribute__(className)().importAPI(cmsIP,"%s/%s.xml"
		% (directory, className)), importsAPI)
	
	return

def main(options):
	importDirectory = options.directory
	cmsIP = options.cmsHost
	
	if os.path.exists(os.path.join(importDirectory, "rcs")):
		setupRCS(options, os.path.join(importDirectory, "rcs"))
		
	if os.path.exists(os.path.join(importDirectory, "ME")):
		setupME(options, os.path.join(importDirectory, "ME"))
		
	
	if os.path.exists(os.path.join(importDirectory, "resources")):
		configReplaceParams(os.path.join(importDirectory, "resources"), "/", [])
	
	imports = [
		"LookupKeys",
		"LookupKeysAssetType",
		"Partners",
		"PartnerProperties",
		"SelectorKeys",
		"CustomFieldsGroups",
		"CustomFields",
		"Resources",
		"ResourceGroupMembership",
		"ContentClassPartners",
		"Rulesets"
	]
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (importDirectory, className)), imports)
	
	if os.path.exists(os.path.join(importDirectory, "Sites")):
		setupSites(options, os.path.join(importDirectory, "Sites"))
	
	if os.path.exists(os.path.join(importDirectory, "MSO")):
		setupMSO(cmsIP,options, os.path.join(cmsIP,importDirectory, "MSO"))
		
	if os.path.exists(os.path.join(importDirectory, "CMLicense")):
		setupCMLicense(cmsIP,options, os.path.join(cmsIP,importDirectory, "CMLicense"))
	
	importContentClassesAndRules(options)

	imports = [
		"ContentClassPartners",
		"Rulesets"
	]
	
	map(lambda className : __import__(className).__getattribute__(className)().importFromFile("%s/%s.tdf"
		% (importDirectory, className)), imports)

	print 'Restarting CMS'
	
	os.system('service cms restart; service tomcat restart;')
#	time.sleep(180) 
	code = 0
	while code != 200:
		print "Starting cms serice, please be patient..."
		sys.stdout.flush()
		time.sleep(5)
		try:
			resp = urllib2.urlopen("https://%s:8443/portal" % (options.cmsHost), timeout=5)
			code = resp.code
		except Exception: {}

	importSeries(options, os.path.join(importDirectory, "Series/"))

def usage():
	return "Usage: %prog [options]"

if __name__ == "__main__":
	import optparse
	import cx_Oracle
	
	parser = optparse.OptionParser(usage=usage())
	parser.add_option("-d", "--directory", dest="directory", metavar="directory", default="cmsexport", help="Directory to import the exported files from.")
	parser.add_option("--cms-host", dest="cmsHost", metavar="host", default="watchpoint-app", help="Hostname/IP of the import CMS.")
	parser.add_option("--cms-port", dest="cmsPort", metavar="port", default="8443", help="Port of the import CMS.")
	parser.add_option("--cms-user", dest="cmsUser", metavar="user", default="admin", help="CMS username.")
	parser.add_option("--cms-password", dest="cmsPassword", metavar="password", default="admin", help="CMS password.")
	
	parser.add_option("--database-host", dest="databaseHost", metavar="host", default="dbserver", help="Hostname/IP of the import database.")
	parser.add_option("--database-port", dest="databasePort", metavar="port", default=1521, help="Port of the import database.")
	parser.add_option("--database-sid", dest="databaseSid", metavar="sid", default="ttv", help="Database SID.")
	parser.add_option("--database-user", dest="databaseUser", metavar="user", default="wfs", help="Database username.")
	parser.add_option("--database-password", dest="databasePassword", metavar="password", default="Wf$1234", help="Database password.")
	
	parser.add_option("--rcs-database-user", dest="rcsdatabaseUser", metavar="rcsuser", default="rcs", help="RCS Database username.")
	parser.add_option("--rcs-database-password", dest="rcsdatabasePassword", metavar="rcspassword", default="RcS1234", help="RCS Database password.")
	
	options, args = parser.parse_args()
	
	dsn = cx_Oracle.makedsn(options.databaseHost, options.databasePort, options.databaseSid)
	BaseClass.BaseClass.setConnection(cx_Oracle.connect(options.databaseUser, options.databasePassword, dsn))
	main(options)
