#!/usr/bin/env python
import BaseClass

class LookupKeys(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "NAME, DESCRIPTION"
        self.table = "CMS_LOOKUP_KEY"
        self.setSelectStatement()
    
    def checkExistence(self, data):
        name = data[0]
        self.cursor.execute("SELECT ID FROM CMS_LOOKUP_KEY WHERE NAME='%s'" % name)
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        self.cursor.execute("SELECT WFS.CMS_LOOKUP_KEY_SEQ.NEXTVAL FROM DUAL")
        return self.cursor.fetchall()[0][0]
    
    def insert(self, id_, data):
        try:
            statement = "INSERT INTO CMS_LOOKUP_KEY (ID, NAME, DESCRIPTION) "\
                                "VALUES %s" % str(tuple([id_] + list(data)))
            print statement
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = LookupKeys()
    l.export("/tmp/lookupkeys.tdf")
    
if __name__ == "__main__":
    main()