#!/usr/bin/env python
import BaseClass
import Partners
import urllib2
import base64
import cookielib
from xml.dom.minidom import parseString

class MSO(BaseClass.BaseClass):
    def __init__(self):
        self.username='admin'
        self.password='admin'
    
    def export(self,cmsIP, outputFile):
        try:
            self.url = 'https://%s:8443/services/msos' % (cmsIP)
            self.cj = cookielib.CookieJar()
            self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cj), urllib2.HTTPSHandler())
            
            urllib2.install_opener(self.opener)
            self.request = urllib2.Request(self.url)
            auth = "Basic %s" % base64.b64encode("%s:%s" % (self.username, self.password))
            self.request.add_header("Authorization", auth)
            self.request.add_header('Content-Type', 'application/xml')
            assert self.request.get_method() == 'GET'
            
            """open the request and write the response in an xml file"""
            response = urllib2.urlopen(self.request)
            html = response.read()
            f = file(outputFile, "w")
            f.write(html)
            f.close()
        except Exception:
            try:
                """opening the request again helps to save the cookie for further authentication"""
                response = urllib2.urlopen(self.request)
                html = response.read()
            except Exception, e:
                print e    
    
    def importAPI(self,cmsIP, xml):
        try:
            self.url = 'https://%s:8443/services/msos' % (cmsIP)

            file = open(xml,'r')
            data = file.read()
            file.close()
            
            dom = parseString(data)
            xmlns = dom.getElementsByTagName("ResourceList")[0].getAttribute("xmlns")
            for MSOTag in dom.getElementsByTagName("Mso"):
                """
                create the request for every post method call to be made
                and add the respective necessary headers 
                """
                self.request = urllib2.Request(self.url)
                auth = "Basic %s" % base64.b64encode("%s:%s" % (self.username, self.password))
                self.request.add_header("Authorization", auth)
                self.request.add_header('Content-Type', 'application/xml')

                MSOTag.removeAttribute("href")
                MSOTag.setAttribute("xmlns",xmlns)
                xmlData = MSOTag.toxml()

                try:
                    response = urllib2.urlopen(self.request,xmlData,10)
                    html = response.read()
                    print "MSO is Inserted"
                except Exception:
                    try:
                        response = urllib2.urlopen(self.request,xmlData,10)
                        html = response.read()
                    except urllib2.HTTPError , e:
                        errors = parseString(e.read())
                        for error in errors.getElementsByTagName("Error"):
                            print error.firstChild.nodeValue
                                       
        except IOError, e:
            print e
            return

def main():
    s = MSO()
    
if __name__ == "__main__":
    main()