#!/usr/bin/env python
import BaseClass
import Partners

class MSOSites(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        self.columns = "MSO, ASSOCIATED_SITE"
        self.table = "SITES_SITE, SITES_SITELINK"
        self.setSelectStatement()    
        self.selectStatement = "SELECT m.MSO_NAME AS MSO, s.NAME AS ASSOCIATED_SITE "\
            "FROM SITES_MSO_MTM m, SITES_SITE s, SITES_MSO_SITE ms "\
            "WHERE m.MSO_ID = ms.MSO_ID "\
            "AND s.ID_ = ms.SITE_ID "
            
    def checkExistence(self, data):
        mso = data[0]
        self.cursor.execute("SELECT MSO_ID FROM SITES_MSO_MTM WHERE MSO_NAME = '%s'" % mso)
        rowsMSO = self.cursor.fetchall()
        
        site = data[1]
        self.cursor.execute("SELECT ID_ FROM SITES_SITE WHERE NAME='%s'" % site)
        rowsSite = self.cursor.fetchall()
        
        
        self.cursor.execute("SELECT * FROM SITES_MSO_SITE WHERE MSO_ID = %s AND SITE_ID = %s" % (rowsMSO[0][0],rowsSite[0][0]))
        rows = self.cursor.fetchall()
        
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self, id_, data):
        try:
            mso = "SELECT MSO_ID FROM SITES_MSO_MTM WHERE MSO_NAME = '%s'" % (data[0])
            self.cursor.execute(mso)
            rowsMSO = self.cursor.fetchall()
            
            site = "SELECT ID_ FROM SITES_SITE WHERE NAME = '%s'" % (data[1])
            self.cursor.execute(site)
            rowsSite = self.cursor.fetchall()
           
            statement = "INSERT INTO SITES_MSO_SITE (MSO_ID,SITE_ID) VALUES ( %s , %s ) " % (rowsMSO[0][0],rowsSite[0][0])
            print statement 
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            self.rollback()
            
def main():
    s = MSOSites()    
    s.export("/tmp/MSOSites.tdf")
    
if __name__ == "__main__":
    main()