#!/usr/bin/env python
#
# Copyright (c) 2012 Ericsson, Inc.  All Rights Reserved.
#
# This module contains unpublished, confidential, proprietary
# material.  The use and dissemination of this material are
# governed by a license.  The above copyright notice does not
# evidence any actual or intended publication of this material.
#
# Author: Brandon Cox
# Created: Nov 1, 2012
# Description:
# Out of Box Database Configuration Script
#
# $Id: OOBInsert.py,v 1.00 2012/11/12 17:43:28 bcox Exp $
#
#
#

import ContentClassPartners
import CustomFields
import CustomFieldsGroups
import Partners
import ProcessDefinitions
import ResourceGroupMembership
import ResourceGroups
import Resources
import Rulesets
import SelectorKeys
import Sites

import os

def insertPartners():
	lines = file("../conf/Partners.txt", "r").readlines()[1:]
	
	p = Partners.Partners()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		p.add(tuple(fields))

def insertSites():
	lines = file("../conf/Sites.txt", "r").readlines()[1:]
	
	s = Sites.Sites()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		s.add(tuple(fields))

def insertSelectorKeys():
	lines = file("../conf/SelectorKeys.txt", "r").readlines()[1:]
	
	sk = SelectorKeys.SelectorKeys()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		sk.add(tuple(fields))
		
def insertCustomFieldsGroups():
	lines = file("../conf/CustomFieldsGroups.txt", "r").readlines()[1:]
	
	cfg = CustomFieldsGroups.CustomFieldsGroups()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		cfg.add(tuple(fields))

def insertCustomFields():
	lines = file("../conf/CustomFields.txt", "r").readlines()[1:]
	
	cf = CustomFields.CustomFields()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		cf.add(tuple(fields))

def insertResources():
	lines = file("../conf/Resources.txt", "r").readlines()[1:]
	
	r = Resources.Resources()
	cacsIP = os.popen("grep cacs /etc/hosts | awk '{print $1}'", "r").read().strip()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		for x in xrange(len(fields)):
			if fields[x] == "null":
				fields[x] = ""
			elif "http://cacs" in fields[x]:
				fields[x] = fields[x].replace("http://cacs", "http://%s" % cacsIP)

		
		r.add(tuple(fields))
		
def importRulesAndContentClass():
	print "Importing content class and rules.  This could take some time..."
	print os.popen("sh Import.sh", "r").read()

#def importContentClass():
#	pass

def insertContentClassPartners():
	lines = file("../conf/ContentClassPartners.txt", "r").readlines()[1:]
	
	ccp = ContentClassPartners.ContentClassPartners()
	
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		ccp.add(tuple(fields))

def enableRulesets():
	lines = file("../conf/Rulesets.txt", "r").readlines()[1:]
	
	r = Rulesets.Rulesets()
	for line in lines:
		fields = map(lambda s : s.strip(), filter(None, line.split("\t")))
		
		r.enable(tuple(fields))

def restartCMS():
	print os.popen("service cms restart", "r").read()

def main():
	insertPartners()
	insertSites()
	insertSelectorKeys()
	insertCustomFieldsGroups()
	insertCustomFields()
	insertResources()
	importRulesAndContentClass()
	insertContentClassPartners()
	enableRulesets()
	#restartCMS()

if __name__ == "__main__":
	main()		