#!/usr/bin/env python
import BaseClass
import Partners

class PartnerProperties(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		self.columns = "PROVIDERID, NAME, VALUE"
		self.table = "PMM_CONTAINER_PROPERTIES"
		
		self.selectStatement = "SELECT P.PROVIDERID, PP.NAME, PP.VALUE "\
		"FROM PMM_CONTAINER_PROPERTIES PP "\
		"JOIN PMM_PARTNER P "\
		"ON (PP.CONTEXTID = P.CONTEXTID)"
		
	def checkExistence(self, data):
		self.contextId = Partners.Partners().checkExistence((None, None, data[0]))
		self.cursor.execute("SELECT ID FROM PMM_CONTAINER_PROPERTIES WHERE CONTEXTID=%s AND NAME='%s'" % (
			self.contextId, data[1]))
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
	
	def getNextId(self):
		self.cursor.execute("SELECT WFS.PMM_CONTAINER_PROPERTIES_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO PMM_CONTAINER_PROPERTIES (ID, CONTEXTID, NAME, VALUE) VALUES %s" % (
				str(tuple([id_, self.contextId] + list(data[1 : ]))))
			print statement
			self.cursor.execute(statement)
		
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

def main():
	pp = PartnerProperties()
	#pp.export("/tmp/pp.tdf")
	pp.importFromFile("/tmp/pp.tdf")

if __name__ == "__main__":
	main()