#!/usr/bin/env python
import BaseClass

class Partners(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, PARTNERTYPE, PROVIDERID, LOOKUPKEY"
		self.table = "PMM_PARTNER"
		self.setSelectStatement()
		self.selectStatement += " WHERE PARTNERTYPE!=1 AND ISACTIVE=1"
	
	def checkExistence(self, data):
		providerId = data[2]
		self.cursor.execute("SELECT ID_ FROM PMM_PARTNER WHERE PROVIDERID='%s' AND ISACTIVE=1" % providerId)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		
		self.cursor.execute("SELECT WFS.PMM_CONTEXT_SEQ.NEXTVAL FROM DUAL")
		self.cursor.execute("SELECT WFS.PMM_PARTNER_SEQ.NEXTVAL FROM DUAL")
		self.cursor.execute("SELECT WFS.PMM_CONTACT_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO PMM_CONTEXT (ID_, CONTAINERTYPEID) VALUES (%s, 1)" % id_
			print statement
			self.cursor.execute(statement)
			
			statement = "INSERT INTO PMM_PARTNER (ID_, CONTEXTID, NAME, PARTNERTYPE, PROVIDERID, LOOKUPKEY, ISACTIVE) "\
								"VALUES %s" % str(tuple([id_] * 2 + list(data) + [1]))
			print statement
			self.cursor.execute(statement)
			
			statement = "INSERT INTO PMM_CONTACT (ID_, PARTNERID) VALUES (%s, %s)" % (id_, id_)
			print statement
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()
	
#	def _export(self):
#		statement = "SELECT NAME, PROVIDERID, PARTNERTYPE, LOOKUPKEY FROM PMM_PARTNER WHERE PARTNERTYPE!=1"
#		header = "NAME, PROVIDERID, PARTNERTYPE, LOOKUPKEY".replace(", ", "\t")
#		print statement
#		self.execute(statement)
#		rows = self.fetchall()
#		
#		output = header + "\n"
#		for row in rows:
#			output += "\t".join(self.noneToNull(row)) + "\n"
#		
#		return output.strip()

def main():
	p = Partners()
	#p.add("testscript.com", 2, "testscript.com")
	p.export("/tmp/partners.tdf")
	#p.importFromFile("/tmp/partners.tdf")
	
if __name__ == "__main__":
	main()