#!/usr/bin/env python
import BaseClass
import os

class RCSEPGProvider(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        os.system('chmod 777 /usr/local/tstv/EpgDownload;')
        self.columns = "NAME,PATH,EPG_READ_FREQUENCY,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE"
        self.selectStatement = "SELECT NAME,PATH,EPG_READ_FREQUENCY,CREATED_BY,UPDATED_BY,"\
            "TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM')"\
            "FROM RCS.EPG_PROVIDER_CONFIG"
    
    def checkExistence(self, data):
        name = data[0]
        self.cursor.execute("SELECT EPG_PROVIDER_ID FROM RCS.EPG_PROVIDER_CONFIG WHERE NAME='%s'" % name)
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "INSERT INTO RCS.EPG_PROVIDER_CONFIG (NAME,PATH,EPG_READ_FREQUENCY,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE) "\
                                "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
            self.commit()
            os.system('service cms stop; service RCSSchedulerService stop; sleep 10;')
            os.system('service cms start; service RCSSchedulerService start; sleep 300;')
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSEPGProvider()
    l.export("\RCSEPGProvider.tdf")
    
if __name__ == "__main__":
    main()
