#!/usr/bin/env python
import BaseClass

class RCSRMConfig(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "PARENT_RM_ID,NAME,IP_ADDRESS,PORT,BACK_OFFICE_IP_ADDRESS,BACK_OFFICE_PORT,EXPORT_ATTEMPTS,EXPORT_ATTEMPTS_INTERVAL,OPERATIONAL_STATE,REQUESTED_STATE,IS_DELETED,PRE_PROVISIONING_INTERVAL,START_BLACK_OUT,STOP_BLACK_OUT,STOP_SUPPORTED,PACKAGER_URL,RM_TYPE,VERSION,SENT_TO_RM,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,HEADEND_ID"
        self.table = "RCS.RM"
        self.selectStatement = "SELECT PARENT_RM_ID,NAME,IP_ADDRESS,PORT,BACK_OFFICE_IP_ADDRESS,"\
        "BACK_OFFICE_PORT,EXPORT_ATTEMPTS,EXPORT_ATTEMPTS_INTERVAL,OPERATIONAL_STATE,REQUESTED_STATE,"\
        "IS_DELETED,PRE_PROVISIONING_INTERVAL,START_BLACK_OUT,STOP_BLACK_OUT,STOP_SUPPORTED,PACKAGER_URL,"\
        "RM_TYPE,VERSION,SENT_TO_RM,CREATED_BY,UPDATED_BY,TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),"\
        "TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),HEADEND_ID "\
        "FROM RCS.RM "\
        "WHERE IS_DELETED=0"
    
    def checkExistence(self, data):
        name = data[1] 
        self.cursor.execute("SELECT RM_ID FROM RCS.RM WHERE NAME='%s' AND IS_DELETED=0" % name)
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "INSERT INTO RCS.RM (PARENT_RM_ID,NAME,IP_ADDRESS,PORT,BACK_OFFICE_IP_ADDRESS,BACK_OFFICE_PORT,EXPORT_ATTEMPTS,EXPORT_ATTEMPTS_INTERVAL,OPERATIONAL_STATE,REQUESTED_STATE,IS_DELETED,PRE_PROVISIONING_INTERVAL,START_BLACK_OUT,STOP_BLACK_OUT,STOP_SUPPORTED,PACKAGER_URL,RM_TYPE,VERSION,SENT_TO_RM,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,HEADEND_ID)"\
                         "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSRMConfig()
    l.export("\RCSRMConfig.tdf")
    
if __name__ == "__main__":
    main()