#!/usr/bin/env python
import BaseClass

class RCSRMLineup(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "RM_ID, STATION_ID,HEADEND_ID,LINEUP_ID,MULTICAST_IP_ADDRESS,MULTICAST_PORT,OFFSET,SD_MIN_BITRATE,SD_MAX_BITRATE,HD_MIN_BITRATE,HD_MAX_BITRATE,CHANNEL_NUMBER,LOCATION,MEDIATYPE,MANIFESTNAME,PUBLISHPOINT,SENT_TO_RM,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE"
        self.selectStatement = "SELECT RM_ID, STATION_ID,HEADEND_ID,LINEUP_ID,MULTICAST_IP_ADDRESS,"\
            "MULTICAST_PORT,OFFSET,SD_MIN_BITRATE,SD_MAX_BITRATE,HD_MIN_BITRATE,HD_MAX_BITRATE,"\
            "CHANNEL_NUMBER,LOCATION,MEDIATYPE,MANIFESTNAME,PUBLISHPOINT,SENT_TO_RM,CREATED_BY,UPDATED_BY,"\
            "TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM')"\
            " FROM RCS.RM_LINEUP"

    def checkExistence(self, data):
        rmid = data[0]
        stationid = data[1] 
        self.cursor.execute("SELECT RM_ID FROM RCS.RM_LINEUP WHERE STATION_ID = '%s' AND RM_ID = '%s'" % ( stationid ,rmid))
        rows = self.cursor.fetchall()
        if len(rows):    
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "Insert into RCS.RM_LINEUP (RM_ID, STATION_ID,HEADEND_ID,LINEUP_ID,MULTICAST_IP_ADDRESS,MULTICAST_PORT,OFFSET,SD_MIN_BITRATE,SD_MAX_BITRATE,HD_MIN_BITRATE,HD_MAX_BITRATE,CHANNEL_NUMBER,LOCATION,MEDIATYPE,MANIFESTNAME,PUBLISHPOINT,SENT_TO_RM,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE) "\
                         "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSRMLineup()
    l.export("\RCSRMLineup.tdf")
    
if __name__ == "__main__":
    main()