#!/usr/bin/env python
import BaseClass

class RCSRTC(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "NAME,IP_ADDRESS,PORT,CAPACITY,MAXIMUM_BAND_WIDTH,MAXIMUM_STORAGE,OPERATIONAL_STATE,REQUESTED_STATE,SERVICE_NAME,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,POOL_ID,USER_ID,PASSWORD,DOMAIN,HOST_IP_ADDRESS,VERSION,SENT_TO_RM"
        self.table = "RCS.RTC"
        self.selectStatement = "SELECT NAME,IP_ADDRESS,PORT,CAPACITY,MAXIMUM_BAND_WIDTH,MAXIMUM_STORAGE,"\
            "OPERATIONAL_STATE,REQUESTED_STATE,SERVICE_NAME,CREATED_BY,UPDATED_BY,"\
            "TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM')"\
            "POOL_ID,USER_ID,PASSWORD,DOMAIN,HOST_IP_ADDRESS,VERSION,SENT_TO_RM"\
            " FROM RCS.RTC"
    
    def checkExistence(self, data):
        name = data [0]
        servicename = data[8] 
        self.cursor.execute("SELECT NAME FROM RCS.RTC WHERE SERVICE_NAME = '%s' OR NAME = '%s'" % (servicename, name))
        rows = self.cursor.fetchall()
        if len(rows):    
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "INSERT INTO RCS.RTC(NAME,IP_ADDRESS,PORT,CAPACITY,MAXIMUM_BAND_WIDTH,MAXIMUM_STORAGE,OPERATIONAL_STATE,REQUESTED_STATE,SERVICE_NAME,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,POOL_ID,USER_ID,PASSWORD,DOMAIN,HOST_IP_ADDRESS,VERSION,SENT_TO_RM)"\
                                     "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSRTC()
    l.export("\RCSRTC.tdf")
    
if __name__ == "__main__":
    main()