#!/usr/bin/env python
import BaseClass

class RCSRTCpool(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "NAME,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,RM_ID"
        self.selectStatement = "SELECT NAME,CREATED_BY,UPDATED_BY,"\
        "TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM')"\
        "RM_ID FROM RCS.RTC_POOL"
    
    def checkExistence(self, data):
        name = data[0] 
        self.cursor.execute("SELECT POOL_ID FROM RCS.RTC_POOL WHERE NAME = '%s'"  % name )
        rows = self.cursor.fetchall()
        if len(rows):    
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "Insert into RCS.RTC_POOL (NAME,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE,RM_ID)  "\
                         "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
            
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSRTCpool()
    l.export("\RCSRTCpool.tdf")
    
if __name__ == "__main__":
    main()