#!/usr/bin/env python
import BaseClass
import os

class RCSTrialuse(BaseClass.BaseClass):
    def __init__(self):
        BaseClass.BaseClass.__init__(self)
        
        self.columns = "TRIAL_USE_FIELD_ID,ASSET_TYPE,NAME,VALUE_TYPE,VALUE,MAPPING_ID,DESCRIPTION,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE"
        self.table = "RCS.TRIAL_USE_DEFINITION"
        self.selectStatement = "SELECT TRIAL_USE_FIELD_ID,ASSET_TYPE,NAME,VALUE_TYPE,VALUE,MAPPING_ID,DESCRIPTION,CREATED_BY,UPDATED_BY,"\
            "TO_CHAR(CREATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM'),TO_CHAR(UPDATE_DATE, 'DD-MON-RR HH.MI.SS.FF AM')"\
            " FROM RCS.TRIAL_USE_DEFINITION"
    
    def checkExistence(self, data):
        id = data[0]
        self.cursor.execute("SELECT NAME FROM RCS.TRIAL_USE_DEFINITION WHERE TRIAL_USE_FIELD_ID='%s'" % id)
        rows = self.cursor.fetchall()
        if len(rows):
            return rows[0][0]
        else:
            return False
        
    def getNextId(self):
        return 1
    
    def insert(self,id_, data):
        try:
            statement = "INSERT INTO RCS.TRIAL_USE_DEFINITION (TRIAL_USE_FIELD_ID,ASSET_TYPE,NAME,VALUE_TYPE,VALUE,MAPPING_ID,DESCRIPTION,CREATED_BY,UPDATED_BY,CREATE_DATE,UPDATE_DATE) "\
                                "VALUES %s" % str(tuple(list(data)))
            print statement
            self.cursor.execute(statement)
                       
            return self.commit()
        except Exception, e:
            print e
            return self.rollback()
    
def main():
    l = RCSTrialuse()
    l.export("\RCSTrialuse.tdf")
    
if __name__ == "__main__":
    main()