#!/usr/bin/env python
import BaseClass
import Resources
import ResourceGroups

class ResourceGroupMembership(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "RESOURCENAME, RESOURCEGROUPNAME"
		self.selectStatement = "SELECT R.NAME AS RESOURCENAME, RG.NAME AS RESOURCEGROUPNAME "\
			"FROM TTV_RESOURCEGROUPMEMBERSHIP RGM "\
  			"JOIN TTV_RESOURCE R "\
     		"ON (RGM.RESOURCEID = R.RESOURCEID) "\
  	    	"JOIN TTV_RESOURCEGROUP RG "\
      	 	"ON (RGM.RESOURCEGROUPID = RG.RESOURCEGROUPID)"
	
	def checkExistence(self, data):
		resourceName = data[0]
		self.resourceId = Resources.Resources().checkExistence([resourceName])
		if not self.resourceId:
			print("No resource found for resourceName: " + resourceName)
			print("Cannot insert ResourceGroupMembership...")
			return
		
		groupName = data[1]
		self.groupId = ResourceGroups.ResourceGroups().checkExistence(tuple([groupName]))
		if not self.groupId:
			print("No group found for groupName: " + groupName)
			print("Cannot insert ResourceGroupMembership...")
			return
		
		self.cursor.execute("SELECT * FROM TTV_RESOURCEGROUPMEMBERSHIP WHERE RESOURCEID=%s AND RESOURCEGROUPID=%s" % (self.resourceId, self.groupId))
		rows = self.cursor.fetchall()
		if len(rows):
			return True
		else:
			return False
		
	def getNextId(self):
		return 1
		try:
			return self.cursor.fetchall()[0][0] + 1
		except:
			return 1
	
	def insert(self, id_, data):
		try:
			statement = "INSERT INTO TTV_RESOURCEGROUPMEMBERSHIP (RESOURCEID, RESOURCEGROUPID) VALUES %s" % str(
				tuple([self.resourceId, self.groupId]))
			print statement 
			self.cursor.execute(statement)
			
			return self.commit()
		except Exception, e:
			print e
			return self.rollback()

def main():
	rgm = ResourceGroupMembership()
	#rgm.checkExistence(("MDMS", "AMI"))
	rgm.export("/tmp/rgm.tdf")
	
if __name__ == "__main__":
	main()