#!/usr/bin/env python
import BaseClass
import ResourceGroupMembership

class Resources(BaseClass.BaseClass):
	def __init__(self):
		BaseClass.BaseClass.__init__(self)
		
		self.columns = "NAME, RESOURCETYPENAME, CONNECTIONSTRING, MAXCONCURRENTUSERS, ADMINISTRATIVERESOURCESTATUSID, "\
			"OPERATIONALRESOURCESTATUSID, HEARTBEATCONNECTIONSTRING, HEARTBEATFREQUENCY, ISACTIVE, IGNORETIMEOUT, USER_NAME"
		self.selectStatement = "SELECT R.NAME, RT.NAME AS RESOURCETYPENAME, R.CONNECTIONSTRING, R.MAXCONCURRENTUSERS, R.ADMINISTRATIVERESOURCESTATUSID, R.OPERATIONALRESOURCESTATUSID, R.HEARTBEATCONNECTIONSTRING, R.HEARTBEATFREQUENCY, R.ISACTIVE, R.IGNORETIMEOUT, R.USER_NAME "\
			"FROM TTV_RESOURCE R "\
			"JOIN TTV_RESOURCETYPE RT "\
    		"ON (R.RESOURCETYPEID = RT.RESOURCETYPEID)"
	
	
	def checkExistence(self, data):
		resourceName = data[0]
		self.cursor.execute("SELECT RESOURCEID FROM TTV_RESOURCE WHERE NAME='%s' AND ISACTIVE=1" % resourceName)
		rows = self.cursor.fetchall()
		if len(rows):
			return rows[0][0]
		else:
			return False
		
	def getNextId(self):
		self.cursor.execute("SELECT WFS.TTV_RESOURCE_SEQ.NEXTVAL FROM DUAL")
		return self.cursor.fetchall()[0][0]
	
	def insert(self, id_, data):
		try:
			resourceTypeId = self.getResourceTypeId(data[1])
			statement = "INSERT INTO TTV_RESOURCE (RESOURCEID, RESOURCETYPEID, NAME, CONNECTIONSTRING, MAXCONCURRENTUSERS, ADMINISTRATIVERESOURCESTATUSID, "\
			"OPERATIONALRESOURCESTATUSID, HEARTBEATCONNECTIONSTRING, HEARTBEATFREQUENCY, ISACTIVE, IGNORETIMEOUT, USER_NAME) VALUES %s" % str(
				tuple([id_, resourceTypeId, data[0]] + list(data[2:])))
			print statement 
			self.cursor.execute(statement)
			
			
			#rgm = ResourceGroupMembership.ResourceGroupMembership()
			#if rgm.add(data[0], data[2]):
			return self.commit()
			#else:
			#	return self.rollback()
		except Exception, e:
			print e
			return self.rollback()
	
	def getResourceTypeId(self, resourceTypeName):
		self.cursor.execute("SELECT RESOURCETYPEID FROM TTV_RESOURCETYPE WHERE NAME='%s'" % resourceTypeName)
		return self.cursor.fetchall()[0][0]
	
#	def getResources(self):
#		"""select r.NAME, rt.NAME as RESOURCETYPENAME, rg.NAME as RESOURCEGROUPNAME, r.connectionstring, r.maxconcurrentusers, r.administrativeresourcestatusid, r.operationalresourcestatusid, r.heartbeatconnectionstring, r.heartbeatfrequency, r.isactive, r.ignoretimeout, r.user_name
#		from ttv_resource r
#		join ttv_resourcetype rt
#  			on (r.resourcetypeid = rt.resourcetypeid)
#		join ttv_resourcegroup rg
#  			on (r.name = rg.name)"""

def main():
	r = Resources()
	#r.add("MDMS45", "AMI", "AMI", "http://10.243.90.45:8300/assets", 2, 2, 2, "http://10.243.90.45:8300/assets", 60, 1, 1, "")
	r.export("/tmp/resources.tdf")
	
if __name__ == "__main__":
	main()